/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.builtintypes;

import java.util.Arrays;
import java.util.UUID;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.Enumeration;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.ExtensionObject;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedLong;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.XmlElement;
import org.opcfoundation.ua.utils.MultiDimensionArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Variant {
    private static Logger logger = LoggerFactory.getLogger(Variant.class);
    public static final Variant NULL = new Variant(null);
    Object value;
    Class<?> compositeClass;

    public Variant(Object object) {
        if (object instanceof Enumeration) {
            object = ((Enumeration)object).getValue();
        }
        this.value = object;
        if (object != null) {
            this.compositeClass = object.getClass();
            if (this.compositeClass == Variant.class) {
                throw new IllegalArgumentException("Variant cannot be " + this.compositeClass.getCanonicalName());
            }
            while (this.compositeClass.isArray() && !this.compositeClass.equals(byte[].class)) {
                this.compositeClass = this.compositeClass.getComponentType();
            }
            this.assertValidClass(this.compositeClass);
        }
    }

    void assertValidClass(Class<?> clazz) {
        if (clazz.equals(byte[].class)) {
            return;
        }
        if (clazz.equals(Boolean.class)) {
            return;
        }
        if (clazz.equals(Byte.class)) {
            return;
        }
        if (clazz.equals(UnsignedByte.class) && !clazz.isArray()) {
            return;
        }
        if (clazz.equals(Short.class)) {
            return;
        }
        if (clazz.equals(UnsignedShort.class)) {
            return;
        }
        if (clazz.equals(Integer.class)) {
            return;
        }
        if (clazz.equals(UnsignedInteger.class)) {
            return;
        }
        if (clazz.equals(Long.class)) {
            return;
        }
        if (clazz.equals(UnsignedLong.class)) {
            return;
        }
        if (clazz.equals(Float.class)) {
            return;
        }
        if (clazz.equals(Double.class)) {
            return;
        }
        if (clazz.equals(String.class)) {
            return;
        }
        if (clazz.equals(DateTime.class)) {
            return;
        }
        if (clazz.equals(UUID.class)) {
            return;
        }
        if (clazz.equals(XmlElement.class)) {
            return;
        }
        if (clazz.equals(NodeId.class)) {
            return;
        }
        if (clazz.equals(ExpandedNodeId.class)) {
            return;
        }
        if (clazz.equals(StatusCode.class)) {
            return;
        }
        if (clazz.equals(QualifiedName.class)) {
            return;
        }
        if (clazz.equals(LocalizedText.class)) {
            return;
        }
        if (clazz.equals(ExtensionObject.class)) {
            return;
        }
        if (clazz.equals(DataValue.class)) {
            return;
        }
        if (clazz.equals(DiagnosticInfo.class)) {
            return;
        }
        if (clazz.equals(Variant.class)) {
            return;
        }
        if (Structure.class.isAssignableFrom(clazz)) {
            return;
        }
        if (Enumeration.class.isAssignableFrom(clazz)) {
            return;
        }
        throw new IllegalArgumentException("Variant cannot be " + clazz.getCanonicalName());
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public boolean isArray() {
        if (this.value == null) {
            return false;
        }
        Class<?> clazz = this.value.getClass();
        return clazz.isArray() && !clazz.equals(byte[].class);
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toStringWithType() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        String string;
        if (this.value == null) {
            return "(null)";
        }
        String string2 = "";
        if (this.isArray()) {
            if (bl) {
                int[] nArray = this.getArrayDimensions();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(nArray[0]);
                for (int i = 1; i < this.getDimension(); ++i) {
                    stringBuilder.append(",").append(nArray[i]);
                }
                string2 = String.format("(%s[%s]) ", this.compositeClassToString(), stringBuilder.toString());
            }
            string = MultiDimensionArrayUtils.toString(this.value);
        } else {
            if (bl) {
                string2 = String.format("(%s) ", this.compositeClassToString());
            }
            string = MultiDimensionArrayUtils.toString(this.value);
        }
        return string2 + string;
    }

    protected String compositeClassToString() {
        String string = this.compositeClass.getSimpleName();
        return string;
    }

    public Class<?> getCompositeClass() {
        return this.compositeClass;
    }

    public int[] getArrayDimensions() {
        int n = this.getDimension();
        int[] nArray = new int[n];
        if (n == 0) {
            return nArray;
        }
        Object object = this.value;
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = (Object[])object;
            nArray[i] = objectArray.length;
            if (objectArray.length == 0) break;
            object = objectArray[0];
        }
        return nArray;
    }

    public int getDimension() {
        int n = MultiDimensionArrayUtils.getDimension(this.value);
        if (this.compositeClass.isArray()) {
            --n;
        }
        return n;
    }

    public int hashCode() {
        if (this.value == null) {
            return 0;
        }
        if (!this.isArray()) {
            return this.value.hashCode();
        }
        if (this.value instanceof byte[]) {
            return Arrays.hashCode((byte[])this.value);
        }
        return Arrays.deepHashCode((Object[])this.value);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Variant)) {
            return false;
        }
        Variant variant = (Variant)object;
        if (this.value == null && variant.value == null) {
            return true;
        }
        if (this.value == null && variant.value != null) {
            return false;
        }
        if (this.value != null && variant.value == null) {
            return false;
        }
        Class<?> clazz = this.value.getClass();
        if (!clazz.equals(variant.value.getClass())) {
            return false;
        }
        if (clazz == byte[].class) {
            return Arrays.equals((byte[])variant.value, (byte[])this.value);
        }
        if (!this.isArray()) {
            return this.value.equals(variant.value);
        }
        return Arrays.deepEquals((Object[])this.value, (Object[])variant.value);
    }

    public <T> T asClass(Class<T> clazz, T t) {
        if (this.value == null) {
            return t;
        }
        try {
            return clazz.cast(this.value);
        }
        catch (ClassCastException classCastException) {
            return t;
        }
    }

    public boolean booleanValue() {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        if (this.isNumber()) {
            return this.longValue() != 0L;
        }
        if (this.isEmpty()) {
            throw new ClassCastException("Variant null cannot be cast to boolean");
        }
        if (this.getCompositeClass().equals(String.class)) {
            String string = ((String)this.getValue()).toLowerCase();
            if (string.equals("true") || string.equals("1")) {
                return true;
            }
            if (string.equals("false") || string.equals("0")) {
                return false;
            }
            throw new ClassCastException("Variant String cannot be cast to boolean: " + string);
        }
        return this.asClass(Boolean.class, false);
    }

    public Number toNumber() {
        if (this.value instanceof Boolean) {
            return this.booleanValue() ? 1 : 0;
        }
        if (this.isNumber()) {
            return (Number)this.value;
        }
        throw new ClassCastException("Variant is not a Number; CompositeClass=" + this.compositeClass);
    }

    public boolean isNumber() {
        return this.value instanceof Number || this.value instanceof Boolean;
    }

    public boolean isComparable() {
        return this.value instanceof Comparable;
    }

    public int intValue() {
        return this.toNumber().intValue();
    }

    public long longValue() {
        return this.toNumber().longValue();
    }

    public float floatValue() {
        return this.toNumber().floatValue();
    }

    public double doubleValue() {
        return this.toNumber().doubleValue();
    }

    public byte byteValue() {
        return this.toNumber().byteValue();
    }

    public short shortValue() {
        return this.toNumber().shortValue();
    }

    public int compareTo(Variant variant) {
        if (variant == null) {
            throw new NullPointerException("cannot compare to null");
        }
        if (this.isEmpty() && variant.isEmpty()) {
            return 0;
        }
        if (this.isEmpty()) {
            return -1;
        }
        if (variant.isEmpty()) {
            return 1;
        }
        if (this.isNumber() && variant.isNumber()) {
            float f = this.floatValue() - variant.floatValue();
            return (int)Math.signum(f);
        }
        if (this.isComparable()) {
            Object object = this.getCompositeClass().equals(variant.getCompositeClass()) ? variant.getValue() : variant.asClass(this.getCompositeClass(), null);
            if (object == null) {
                throw new ClassCastException(String.format("Cannot compare the variants of types %s vs. %s", this.getCompositeClass(), variant.getCompositeClass()));
            }
            return ((Comparable)this.getValue()).compareTo(object);
        }
        if (variant.isComparable()) {
            Object object = this.getCompositeClass().equals(variant.getCompositeClass()) ? this.getValue() : this.asClass(variant.getCompositeClass(), null);
            if (object == null) {
                throw new ClassCastException(String.format("Cannot compare the variants of types %s vs. %s", this.getCompositeClass(), variant.getCompositeClass()));
            }
            return ((Comparable)variant.getValue()).compareTo(object);
        }
        throw new ClassCastException(String.format("Cannot compare the variants of types %s vs. %s", this.getCompositeClass(), variant.getCompositeClass()));
    }

    public boolean valueEquals(Variant variant) {
        if (variant == null) {
            return false;
        }
        if (this.isEmpty() || variant.isEmpty()) {
            return false;
        }
        if (this.getCompositeClass().equals(variant.getCompositeClass())) {
            return this.equals(variant);
        }
        if (this.isNumber() && variant.isNumber()) {
            return this.floatValue() == variant.floatValue();
        }
        Object var2_2 = variant.asClass(this.getCompositeClass(), null);
        if (var2_2 != null) {
            return this.equals(new Variant(var2_2));
        }
        return variant.equals(this.asClass(variant.getCompositeClass(), null));
    }
}

