/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.builtintypes;

import java.math.BigInteger;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.core.Identifiers;

public final class UnsignedLong
extends Number
implements Comparable<Number> {
    private static final UnsignedLong[] CACHE = new UnsignedLong[1024];
    private static final long serialVersionUID = 1L;
    public static final NodeId ID = Identifiers.UInt64;
    public static final int SIZE = 64;
    private static final long L_MAX_VALUE = Long.MAX_VALUE;
    private static final long L_HI_BIT = Long.MIN_VALUE;
    private static final BigInteger BI_L_MAX_VALUE = new BigInteger(Long.toString(Long.MAX_VALUE));
    private static final BigInteger BI_MAX_VALUE = new BigInteger("2").pow(64).add(new BigInteger("-1"));
    private static final BigInteger BI_MIN_VALUE = new BigInteger("0");
    private static final BigInteger BI_MID_VALUE = new BigInteger("2").pow(63);
    private static final double D_MID_VALUE = BI_MID_VALUE.doubleValue();
    private static final float F_MID_VALUE = BI_MID_VALUE.floatValue();
    public static final UnsignedLong MAX_VALUE = new UnsignedLong(BI_MAX_VALUE);
    public static final UnsignedLong MIN_VALUE;
    public static final UnsignedLong ZERO;
    public static final UnsignedLong ONE;
    private long value;

    public static UnsignedLong getFromBits(long l) {
        if (l >= 0L && l < (long)CACHE.length) {
            return CACHE[(int)l];
        }
        UnsignedLong unsignedLong = new UnsignedLong(0);
        unsignedLong.value = l;
        return unsignedLong;
    }

    public static UnsignedLong valueOf(long l) {
        if (l >= 0L && l < (long)CACHE.length) {
            return CACHE[(int)l];
        }
        return new UnsignedLong(l);
    }

    public UnsignedLong(BigInteger bigInteger) throws IllegalArgumentException {
        if (bigInteger.compareTo(BI_MIN_VALUE) < 0) {
            throw new IllegalArgumentException("Value underflow");
        }
        if (bigInteger.compareTo(BI_MAX_VALUE) > 0) {
            throw new IllegalArgumentException("Value overflow");
        }
        this.value = bigInteger.compareTo(BI_L_MAX_VALUE) <= 0 ? bigInteger.longValue() : bigInteger.subtract(BI_MID_VALUE).longValue() | Long.MIN_VALUE;
    }

    public UnsignedLong(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Value underflow");
        }
        this.value = n;
    }

    public UnsignedLong(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Value underflow");
        }
        this.value = l;
    }

    public UnsignedLong(String string) {
        BigInteger bigInteger = new BigInteger(string);
        if (bigInteger.compareTo(BI_MIN_VALUE) < 0) {
            throw new IllegalArgumentException("Value underflow");
        }
        if (bigInteger.compareTo(BI_MAX_VALUE) > 0) {
            throw new IllegalArgumentException("Value overflow");
        }
        this.value = bigInteger.compareTo(BI_L_MAX_VALUE) < 0 ? bigInteger.longValue() : bigInteger.subtract(BI_MID_VALUE).longValue() | Long.MIN_VALUE;
    }

    public BigInteger bigIntegerValue() {
        if ((this.value & Long.MIN_VALUE) == Long.MIN_VALUE) {
            return BigInteger.valueOf(this.value & Long.MAX_VALUE).add(BI_MID_VALUE);
        }
        return BigInteger.valueOf(this.value);
    }

    @Override
    public double doubleValue() {
        if ((this.value & Long.MIN_VALUE) == Long.MIN_VALUE) {
            return (double)(this.value & Long.MAX_VALUE) + D_MID_VALUE;
        }
        return this.value;
    }

    @Override
    public float floatValue() {
        if ((this.value & Long.MIN_VALUE) == Long.MIN_VALUE) {
            return (float)(this.value & Long.MAX_VALUE) + F_MID_VALUE;
        }
        return this.value;
    }

    @Override
    public int intValue() {
        if ((this.value & Long.MIN_VALUE) == Long.MIN_VALUE) {
            return (int)(this.value & Integer.MAX_VALUE) | Integer.MIN_VALUE;
        }
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public int compareTo(Number number) {
        long l;
        if ((this.value & Long.MIN_VALUE) == Long.MIN_VALUE ^ (number.longValue() & Long.MIN_VALUE) == Long.MIN_VALUE) {
            if ((this.value & Long.MIN_VALUE) == Long.MIN_VALUE) {
                return 1;
            }
            return -1;
        }
        long l2 = this.longValue();
        return l2 < (l = number.longValue()) ? -1 : (l2 == l ? 0 : 1);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(UnsignedLong.class)) {
            return false;
        }
        UnsignedLong unsignedLong = (UnsignedLong)object;
        return this.value == unsignedLong.value;
    }

    public int hashCode() {
        return (int)this.value | (int)(this.value >> 32);
    }

    public String toString() {
        if ((this.value & Long.MIN_VALUE) == Long.MIN_VALUE) {
            return this.bigIntegerValue().toString();
        }
        return Long.toString(this.value);
    }

    public long toLongBits() {
        return this.value;
    }

    public static UnsignedLong parseUnsignedLong(String string) {
        try {
            return UnsignedLong.valueOf(Long.parseLong(string));
        }
        catch (NumberFormatException numberFormatException) {
            return new UnsignedLong(string);
        }
    }

    public UnsignedLong inc() {
        return UnsignedLong.valueOf(this.getValue() + 1L);
    }

    public UnsignedLong dec() {
        return UnsignedLong.valueOf(this.getValue() - 1L);
    }

    public UnsignedLong add(long l) {
        long l2 = this.getValue() + l;
        if (l > 0L && (this.getValue() < 0L || l2 < this.getValue())) {
            return new UnsignedLong(this.bigIntegerValue().add(BigInteger.valueOf(l)));
        }
        return UnsignedLong.valueOf(l2);
    }

    public UnsignedLong add(UnsignedLong unsignedLong) {
        long l = this.getValue() + unsignedLong.getValue();
        if (unsignedLong.getValue() > 0L && l < this.getValue()) {
            return new UnsignedLong(BigInteger.valueOf(this.getValue()).add(BigInteger.valueOf(unsignedLong.getValue())));
        }
        return UnsignedLong.valueOf(l);
    }

    public UnsignedLong subtract(long l) {
        if (this.getValue() >= 0L && this.getValue() > l) {
            return UnsignedLong.valueOf(this.getValue() - l);
        }
        BigInteger bigInteger = this.bigIntegerValue();
        bigInteger = bigInteger.subtract(BigInteger.valueOf(l));
        return new UnsignedLong(bigInteger);
    }

    public UnsignedLong subtract(UnsignedLong unsignedLong) {
        if (this.getValue() < 0L || unsignedLong.getValue() < 0L) {
            return new UnsignedLong(this.bigIntegerValue().subtract(unsignedLong.bigIntegerValue()));
        }
        return UnsignedLong.valueOf(this.getValue() - unsignedLong.getValue());
    }

    private long getValue() {
        return this.value;
    }

    static {
        ZERO = MIN_VALUE = new UnsignedLong(BI_MIN_VALUE);
        ONE = new UnsignedLong(1);
        UnsignedLong.CACHE[0] = ZERO;
        UnsignedLong.CACHE[1] = ONE;
        for (int i = 2; i < CACHE.length; ++i) {
            UnsignedLong.CACHE[i] = new UnsignedLong(i);
        }
    }
}

