/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.builtintypes;

import org.opcfoundation.ua.builtintypes.UnsignedByte;

public final class UnsignedInteger
extends Number
implements Comparable<Number> {
    private static final UnsignedInteger[] CACHE;
    private static final long serialVersionUID = 8818590379317818155L;
    public static final long L_MAX_VALUE = 0xFFFFFFFFL;
    public static final long L_MIN_VALUE = 0L;
    public static final UnsignedInteger MAX_VALUE;
    public static final UnsignedInteger MIN_VALUE;
    public static final UnsignedInteger ZERO;
    public static final UnsignedInteger ONE;
    private int value;

    public static UnsignedInteger getFromBits(int n) {
        if (n >= 0 && n < CACHE.length) {
            return CACHE[n];
        }
        UnsignedInteger unsignedInteger = new UnsignedInteger();
        unsignedInteger.value = n;
        return unsignedInteger;
    }

    public static UnsignedInteger valueOf(long l) {
        if (l >= 0L && l < (long)CACHE.length) {
            return CACHE[(int)l];
        }
        return new UnsignedInteger(l);
    }

    public static UnsignedInteger max(UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2) {
        return unsignedInteger.longValue() < unsignedInteger2.longValue() ? unsignedInteger2 : unsignedInteger;
    }

    public static UnsignedInteger min(UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2) {
        return unsignedInteger.longValue() < unsignedInteger2.longValue() ? unsignedInteger : unsignedInteger2;
    }

    public UnsignedInteger() {
        this.value = 0;
    }

    public UnsignedInteger(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Value underflow");
        }
        this.value = n;
    }

    public UnsignedInteger(long l) throws IllegalArgumentException {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Value overflow");
        }
        this.value = (int)l;
    }

    public UnsignedInteger(String string) throws IllegalArgumentException {
        long l = Long.parseLong(string);
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Value overflow");
        }
        this.value = (int)l;
    }

    public UnsignedInteger(UnsignedInteger unsignedInteger) {
        this.value = unsignedInteger.value;
    }

    public UnsignedInteger(UnsignedByte unsignedByte) {
        this.value = unsignedByte.getValue();
    }

    public long getValue() {
        return (long)this.value & 0xFFFFFFFFL;
    }

    @Override
    public byte byteValue() {
        return (byte)(this.value & 0xFF);
    }

    @Override
    public double doubleValue() {
        return this.getValue();
    }

    @Override
    public float floatValue() {
        return this.getValue();
    }

    public int toIntBits() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value & 0xFFFFFFFFL;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(UnsignedInteger.class)) {
            return false;
        }
        UnsignedInteger unsignedInteger = (UnsignedInteger)object;
        return this.value == unsignedInteger.value;
    }

    public String toString() {
        return Long.toString((long)this.value & 0xFFFFFFFFL);
    }

    public UnsignedInteger and(UnsignedInteger unsignedInteger) {
        return UnsignedInteger.getFromBits(unsignedInteger.value & this.value);
    }

    public UnsignedInteger and(int n) {
        return UnsignedInteger.getFromBits(this.value & n);
    }

    public UnsignedInteger and(long l) {
        return new UnsignedInteger((long)this.value & l);
    }

    public UnsignedInteger or(UnsignedInteger unsignedInteger) {
        return UnsignedInteger.getFromBits(unsignedInteger.value | this.value);
    }

    public UnsignedInteger or(int n) {
        return UnsignedInteger.getFromBits(this.value | n);
    }

    public UnsignedInteger or(long l) {
        return new UnsignedInteger((long)this.value | l);
    }

    @Override
    public int compareTo(Number number) {
        long l;
        long l2 = this.longValue();
        return l2 < (l = number.longValue()) ? -1 : (l2 == l ? 0 : 1);
    }

    public static UnsignedInteger parseUnsignedInteger(String string) throws NumberFormatException, IllegalArgumentException {
        return UnsignedInteger.valueOf(Long.parseLong(string));
    }

    public UnsignedInteger inc() {
        return UnsignedInteger.valueOf(this.getValue() + 1L);
    }

    public UnsignedInteger dec() {
        return UnsignedInteger.valueOf(this.getValue() - 1L);
    }

    public UnsignedInteger add(int n) {
        return UnsignedInteger.valueOf(this.getValue() + (long)n);
    }

    public UnsignedInteger add(long l) {
        return UnsignedInteger.valueOf(this.getValue() + l);
    }

    public UnsignedInteger add(UnsignedInteger unsignedInteger) {
        return UnsignedInteger.valueOf(this.getValue() + unsignedInteger.getValue());
    }

    public UnsignedInteger subtract(int n) {
        return UnsignedInteger.valueOf(this.getValue() - (long)n);
    }

    public UnsignedInteger subtract(long l) {
        return UnsignedInteger.valueOf(this.getValue() - l);
    }

    public UnsignedInteger subtract(UnsignedInteger unsignedInteger) {
        return UnsignedInteger.valueOf(this.getValue() - unsignedInteger.getValue());
    }

    static {
        int n;
        CACHE = new UnsignedInteger[1024];
        MAX_VALUE = new UnsignedInteger(0xFFFFFFFFL);
        ZERO = MIN_VALUE = new UnsignedInteger(0L);
        ONE = new UnsignedInteger(1);
        UnsignedInteger.CACHE[0] = ZERO;
        UnsignedInteger.CACHE[1] = ONE;
        for (n = 2; n < CACHE.length; ++n) {
            UnsignedInteger.CACHE[n] = new UnsignedInteger(n);
        }
        UnsignedInteger.CACHE[0] = ZERO;
        UnsignedInteger.CACHE[1] = ONE;
        for (n = 2; n < CACHE.length; ++n) {
            UnsignedInteger.CACHE[n] = new UnsignedInteger(n);
        }
    }
}

