/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.builtintypes;

import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.common.StatusCodeDescriptions;
import org.opcfoundation.ua.core.Identifiers;

public final class StatusCode {
    public static final NodeId ID = Identifiers.StatusCode;
    public static final int SEVERITY_MASK = -1073741824;
    public static final int SEVERITY_GOOD = 0;
    public static final int SEVERITY_UNCERTAIN = 0x40000000;
    public static final int SEVERITY_BAD = Integer.MIN_VALUE;
    public static final StatusCode GOOD = StatusCode.getFromBits(0);
    public static final StatusCode BAD = StatusCode.getFromBits(Integer.MIN_VALUE);
    public static final int RES1_MASK = 0x30000000;
    public static final int SUBCODE_MASK = 0xFFF0000;
    public static final int STRUCTURECHANGED_MASK = 32768;
    public static final int SEMANTICSCHANGED_MASK = 16384;
    public static final int RES2_MASK = 12288;
    public static final int INFOTYPE_MASK = 3072;
    public static final int INFOTYPE_DATAVALUE = 1024;
    public static final int INFOBITS_MASK = 1023;
    public static final int LIMITBITS_MASK = 768;
    public static final int LIMITBITS_NONE = 0;
    public static final int LIMITBITS_LOW = 256;
    public static final int LIMITBITS_HIGH = 512;
    public static final int LIMITBITS_CONSTANT = 768;
    public static final int OVERFLOW_MASK = 1152;
    public static final int OVERFLOW_BIT = 128;
    public static final int HISTORIANBITS_MASK = 31;
    public static final int HISTORIANBITS_RAW = 0;
    public static final int HISTORIANBITS_CALCULATED = 1;
    public static final int HISTORIANBITS_INTERPOLATED = 2;
    public static final int HISTORIANBITS_RESERVED = 3;
    public static final int HISTORIANBITS_PARTIAL = 4;
    public static final int HISTORIANBITS_EXTRADATA = 8;
    public static final int HISTORIANBITS_MULTIVALUE = 16;
    private final int value;

    public static StatusCode getFromBits(int n) {
        return new StatusCode(n);
    }

    public StatusCode(UnsignedInteger unsignedInteger) {
        this.value = unsignedInteger.intValue();
    }

    private StatusCode(int n) {
        this.value = n;
    }

    public int getValueAsIntBits() {
        return this.value;
    }

    public UnsignedInteger getValue() {
        return UnsignedInteger.getFromBits(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (!(object instanceof StatusCode)) {
            return false;
        }
        StatusCode statusCode = (StatusCode)object;
        return this.value == statusCode.value;
    }

    public String getDescription() {
        String string = StatusCodeDescriptions.getStatusCodeDescription(this.value);
        if (string == null) {
            return "";
        }
        return string;
    }

    public String getName() {
        if (this.value == StatusCode.GOOD.value) {
            return "GOOD";
        }
        if (this.value == StatusCode.BAD.value) {
            return "BAD";
        }
        String string = StatusCodeDescriptions.getStatusCode(this.value);
        if (string == null) {
            return "";
        }
        return string;
    }

    public String toString() {
        return String.format("%s (0x%08X) \"%s\"", this.getName(), this.value, this.getDescription());
    }

    public boolean isBad() {
        return (this.value & 0xC0000000) == Integer.MIN_VALUE;
    }

    public boolean isGood() {
        return (this.value & 0xC0000000) == 0;
    }

    public boolean isNotBad() {
        return (this.value & 0xC0000000) != Integer.MIN_VALUE;
    }

    public boolean isNotGood() {
        return (this.value & 0xC0000000) != 0;
    }

    public boolean isNotUncertain() {
        return (this.value & 0xC0000000) != 0x40000000;
    }

    public boolean isUncertain() {
        return (this.value & 0xC0000000) == 0x40000000;
    }

    public boolean isSemanticsChanged() {
        return (this.value & 0x4000) != 0;
    }

    public boolean isStructureChanged() {
        return (this.value & 0x8000) != 0;
    }

    public boolean isOverflow() {
        return (this.value & 0x480) != 0;
    }

    public int getSeverity() {
        return this.value & 0xC0000000;
    }

    public int getSubcode() {
        return this.value & 0xFFF0000;
    }

    public int getInfotype() {
        return this.value & 0xC00;
    }

    public int getLimitBits() {
        return this.value & 0x300;
    }

    public int getHistorianBits() {
        return this.value & 0x1F;
    }

    public boolean isStatusCode(UnsignedInteger unsignedInteger) {
        int n = -805371904;
        return (unsignedInteger.intValue() & n) == (this.value & n);
    }

    public boolean equalsStatusCode(StatusCode statusCode) {
        return this.isStatusCode(statusCode.getValue());
    }
}

