/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.builtintypes;

import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.core.Identifiers;

public final class QualifiedName {
    public static final NodeId ID = Identifiers.QualifiedName;
    public static final QualifiedName NULL = new QualifiedName(UnsignedShort.valueOf(0), null);
    public static final QualifiedName DEFAULT_BINARY_ENCODING = new QualifiedName("Default Binary");
    public static final QualifiedName DEFAULT_XML_ENCODING = new QualifiedName("Default XML");
    private int namespaceIndex;
    private String name;

    public QualifiedName(UnsignedShort unsignedShort, String string) {
        this.namespaceIndex = unsignedShort.intValue();
        this.name = string;
    }

    public QualifiedName(int n, String string) {
        if (n < UnsignedShort.MIN_VALUE.intValue() || n > UnsignedShort.MAX_VALUE.intValue()) {
            throw new IllegalArgumentException("namespace index out of bounds");
        }
        this.namespaceIndex = n;
        this.name = string;
    }

    public QualifiedName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name argument must not be null");
        }
        this.namespaceIndex = 0;
        this.name = string;
    }

    public String toString() {
        if (this.namespaceIndex > 0) {
            return this.namespaceIndex + ":" + this.name;
        }
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public int getNamespaceIndex() {
        return this.namespaceIndex;
    }

    public static boolean isNull(QualifiedName qualifiedName) {
        return qualifiedName == null || qualifiedName.equals(NULL);
    }

    public static boolean isNullOrEmpty(QualifiedName qualifiedName) {
        if (QualifiedName.isNull(qualifiedName)) {
            return true;
        }
        return "".equals(qualifiedName.name);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + this.namespaceIndex;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return QualifiedName.isNull(this);
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        QualifiedName qualifiedName = (QualifiedName)object;
        if (this.namespaceIndex != qualifiedName.namespaceIndex) {
            return false;
        }
        return !(this.name == null ? qualifiedName.name != null : !this.name.equals(qualifiedName.name));
    }

    public static QualifiedName parseQualifiedName(String string) {
        String[] stringArray = string.split(":");
        UnsignedShort unsignedShort = UnsignedShort.ZERO;
        String string2 = string;
        if (stringArray.length > 1) {
            try {
                unsignedShort = UnsignedShort.parseUnsignedShort(stringArray[0]);
                string2 = string.substring(stringArray[0].length() + 1);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return new QualifiedName(unsignedShort, string2);
    }
}

