/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.builtintypes;

import java.util.Arrays;
import java.util.UUID;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.common.NamespaceTable;
import org.opcfoundation.ua.common.ServerTable;
import org.opcfoundation.ua.core.IdType;

public class NodeReference {
    public static String OPCUA_NAMESPACE = "http://opcfoundation.org/UA/";
    IdType type;
    String namespaceUri;
    String serverUri;
    Object value;
    int hashCode;

    public static NodeReference createFromNodeId(NodeId nodeId, NamespaceTable namespaceTable, ServerTable serverTable) {
        return new NodeReference(serverTable.getUri(0), namespaceTable.getUri(nodeId.getNamespaceIndex()), nodeId.getValue());
    }

    public static NodeReference createFromNodeId(ExpandedNodeId expandedNodeId, NamespaceTable namespaceTable, ServerTable serverTable) {
        if (expandedNodeId.getNamespaceUri() != null) {
            return new NodeReference(serverTable.getUri(expandedNodeId.getServerIndex().intValue()), expandedNodeId.getNamespaceUri(), expandedNodeId.getValue());
        }
        return new NodeReference(serverTable.getUri(expandedNodeId.getServerIndex().intValue()), namespaceTable.getUri(expandedNodeId.getNamespaceIndex()), expandedNodeId.getValue());
    }

    public NodeReference(String string, String string2, Object object) {
        if (object == null || string2 == null || string == null) {
            throw new IllegalArgumentException("argument is null");
        }
        this.namespaceUri = string2;
        this.serverUri = string;
        if (object instanceof Integer) {
            object = UnsignedInteger.getFromBits((Integer)object);
        }
        this.value = object;
        if (object instanceof UnsignedInteger) {
            this.type = IdType.Numeric;
        } else if (object instanceof String) {
            this.type = IdType.String;
        } else if (object instanceof UUID) {
            this.type = IdType.Guid;
        } else if (object instanceof byte[]) {
            this.type = IdType.Opaque;
        } else {
            throw new IllegalArgumentException("value cannot be " + object.getClass().getName());
        }
        if (!(object instanceof byte[])) {
            this.hashCode += 3 * object.hashCode();
        }
        if (string2 != null) {
            this.hashCode += 13 * string2.hashCode();
        }
        if (string != null) {
            this.hashCode += 17 * string.hashCode();
        }
    }

    public IdType getIdType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getServerUri() {
        return this.serverUri;
    }

    public int hashCode() {
        if (this.type == IdType.Opaque) {
            return this.hashCode + Arrays.hashCode((byte[])this.value);
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (!(object instanceof NodeReference)) {
            return false;
        }
        NodeReference nodeReference = (NodeReference)object;
        if (!nodeReference.getNamespaceUri().equals(this.namespaceUri)) {
            return false;
        }
        if (!nodeReference.getServerUri().equals(this.serverUri)) {
            return false;
        }
        if (nodeReference.type == IdType.Opaque) {
            return Arrays.equals((byte[])this.value, (byte[])nodeReference.value);
        }
        return nodeReference.getValue().equals(this.value);
    }
}

