/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.builtintypes;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.XmlElement;
import org.opcfoundation.ua.common.NamespaceTable;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.encoding.DecodingException;
import org.opcfoundation.ua.encoding.EncodeType;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.encoding.EncoderMode;
import org.opcfoundation.ua.encoding.EncodingException;
import org.opcfoundation.ua.encoding.IEncodeable;
import org.opcfoundation.ua.encoding.binary.BinaryDecoder;
import org.opcfoundation.ua.encoding.binary.BinaryEncoder;
import org.opcfoundation.ua.encoding.binary.EncoderCalc;
import org.opcfoundation.ua.encoding.binary.IEncodeableSerializer;
import org.opcfoundation.ua.encoding.xml.XmlDecoder;
import org.opcfoundation.ua.utils.StackUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionObject {
    private static Logger logger = LoggerFactory.getLogger(ExtensionObject.class);
    Object object;
    ExpandedNodeId typeId;
    Integer hash;
    EncodeType encodeType;

    public static ExtensionObject encode(Structure structure, QualifiedName qualifiedName, IEncodeableSerializer iEncodeableSerializer, EncoderContext encoderContext) throws EncodingException {
        if (structure == null) {
            return null;
        }
        if (qualifiedName.equals(QualifiedName.DEFAULT_BINARY_ENCODING)) {
            return ExtensionObject.binaryEncode(structure, iEncodeableSerializer, encoderContext);
        }
        if (qualifiedName.equals(QualifiedName.DEFAULT_XML_ENCODING)) {
            return ExtensionObject.xmlEncode(structure, iEncodeableSerializer);
        }
        throw new EncodingException(StatusCodes.Bad_DataEncodingUnsupported);
    }

    public static ExtensionObject encode(Structure structure, QualifiedName qualifiedName, EncoderContext encoderContext) throws EncodingException {
        return ExtensionObject.encode(structure, qualifiedName, StackUtils.getDefaultSerializer(), encoderContext);
    }

    public static ExtensionObject binaryEncode(Structure structure, EncoderContext encoderContext) throws EncodingException {
        return ExtensionObject.binaryEncode(structure, StackUtils.getDefaultSerializer(), encoderContext);
    }

    public static ExtensionObject binaryEncode(Structure structure, IEncodeableSerializer iEncodeableSerializer, EncoderContext encoderContext) throws EncodingException {
        encoderContext.setEncodeableSerializer(iEncodeableSerializer);
        EncoderCalc encoderCalc = new EncoderCalc();
        encoderCalc.setEncoderContext(encoderContext);
        iEncodeableSerializer.calcEncodeable(structure.getClass(), structure, encoderCalc);
        byte[] byArray = new byte[encoderCalc.getLength()];
        BinaryEncoder binaryEncoder = new BinaryEncoder(byArray);
        binaryEncoder.setEncoderMode(EncoderMode.NonStrict);
        binaryEncoder.setEncoderContext(encoderContext);
        binaryEncoder.putEncodeable(null, structure);
        return new ExtensionObject(structure.getBinaryEncodeId(), byArray);
    }

    public static ExtensionObject xmlEncode(Structure structure) throws EncodingException {
        throw new EncodingException(StatusCodes.Bad_DataEncodingUnsupported);
    }

    public static ExtensionObject xmlEncode(Structure structure, IEncodeableSerializer iEncodeableSerializer) throws EncodingException {
        throw new EncodingException(StatusCodes.Bad_DataEncodingUnsupported);
    }

    public ExtensionObject(ExpandedNodeId expandedNodeId) {
        if (expandedNodeId == null) {
            throw new IllegalArgumentException("typeId argument must not be null");
        }
        this.typeId = expandedNodeId;
    }

    public ExtensionObject(ExpandedNodeId expandedNodeId, byte[] byArray) {
        if (expandedNodeId == null) {
            throw new IllegalArgumentException("typeId argument must not be null");
        }
        this.typeId = expandedNodeId;
        if (byArray != null) {
            this.object = byArray;
            this.encodeType = EncodeType.Binary;
        }
    }

    public ExtensionObject(ExpandedNodeId expandedNodeId, XmlElement xmlElement) {
        if (expandedNodeId == null) {
            throw new IllegalArgumentException("typeId argument must not be null");
        }
        this.object = xmlElement == null ? new XmlElement("") : xmlElement;
        this.typeId = expandedNodeId;
        this.encodeType = EncodeType.Xml;
    }

    public EncodeType getEncodeType() {
        return this.encodeType;
    }

    public Object getObject() {
        return this.object;
    }

    public ExpandedNodeId getTypeId() {
        return this.typeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IEncodeable> T decode(IEncodeableSerializer iEncodeableSerializer, EncoderContext encoderContext, NamespaceTable namespaceTable) throws DecodingException {
        if (this.object == null) {
            Class<? extends IEncodeable> clazz = iEncodeableSerializer.getClass(this.typeId);
            try {
                return (T)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new DecodingException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new DecodingException(illegalAccessException);
            }
        }
        if (this.object instanceof XmlElement) {
            IEncodeable iEncodeable;
            Class<? extends IEncodeable> clazz = iEncodeableSerializer.getClass(this.typeId);
            logger.debug("decode: typeId={} class={}", (Object)this.typeId, clazz);
            if (clazz == null) {
                throw new DecodingException("No serializer defined for class " + this.typeId);
            }
            encoderContext.setEncodeableSerializer(iEncodeableSerializer);
            XmlDecoder xmlDecoder = new XmlDecoder((XmlElement)this.object, encoderContext);
            try {
                xmlDecoder.setNamespaceTable(namespaceTable);
                boolean bl = xmlDecoder.peek(clazz.getSimpleName());
                if (bl) {
                    xmlDecoder.getStartElement();
                }
                iEncodeable = iEncodeableSerializer.getEncodeable(clazz, xmlDecoder);
                if (bl) {
                    xmlDecoder.getEndElement();
                }
            }
            finally {
                xmlDecoder.close();
            }
            return (T)iEncodeable;
        }
        if (this.object instanceof byte[]) {
            Class<? extends IEncodeable> clazz = iEncodeableSerializer.getClass(this.typeId);
            encoderContext.setEncodeableSerializer(iEncodeableSerializer);
            BinaryDecoder binaryDecoder = new BinaryDecoder((byte[])this.object);
            binaryDecoder.setEncoderContext(encoderContext);
            return (T)iEncodeableSerializer.getEncodeable(clazz, binaryDecoder);
        }
        throw new Error("unexpected");
    }

    public <T extends IEncodeable> T decode(EncoderContext encoderContext) throws DecodingException {
        return this.decode(encoderContext, null);
    }

    public <T extends IEncodeable> T decode(EncoderContext encoderContext, NamespaceTable namespaceTable) throws DecodingException {
        return this.decode(encoderContext.getEncodeableSerializer(), encoderContext, namespaceTable);
    }

    public synchronized int hashCode() {
        if (this.hash == null) {
            this.hash = this.object != null && this.object instanceof byte[] ? Integer.valueOf(this.typeId.hashCode() + 13 * Arrays.hashCode((byte[])this.object)) : (this.object != null && this.object instanceof XmlElement ? Integer.valueOf(this.typeId.hashCode() + 13 * ((XmlElement)this.object).hashCode()) : Integer.valueOf(this.typeId.hashCode()));
        }
        return this.hash;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ExtensionObject)) {
            return false;
        }
        ExtensionObject extensionObject = (ExtensionObject)object;
        if (!extensionObject.typeId.equals(this.typeId)) {
            return false;
        }
        if (this.object == null) {
            return extensionObject.object == null;
        }
        if (this.object instanceof byte[]) {
            if (!(extensionObject.object instanceof byte[])) {
                return false;
            }
            return Arrays.equals((byte[])extensionObject.object, (byte[])this.object);
        }
        if (this.object instanceof XmlElement) {
            if (!(extensionObject.object instanceof XmlElement)) {
                return false;
            }
            return ((XmlElement)extensionObject.object).equals((XmlElement)this.object);
        }
        return false;
    }
}

