/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.builtintypes;

import java.util.List;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.utils.ObjectUtils;

public class DiagnosticInfo {
    public static final NodeId ID = Identifiers.DiagnosticInfo;
    Integer symbolicId;
    Integer namespaceUri;
    Integer localizedText;
    Integer locale;
    String additionalInfo;
    StatusCode innerStatusCode;
    DiagnosticInfo innerDiagnosticInfo;
    List<String> stringTable;
    String[] stringArray;

    public DiagnosticInfo() {
    }

    public DiagnosticInfo(String string, DiagnosticInfo diagnosticInfo, StatusCode statusCode, Integer n, Integer n2, Integer n3, Integer n4) {
        this.additionalInfo = string;
        this.innerDiagnosticInfo = diagnosticInfo;
        this.innerStatusCode = statusCode;
        this.locale = n;
        this.localizedText = n2;
        this.namespaceUri = n3;
        this.symbolicId = n4;
    }

    public DiagnosticInfo(String string, DiagnosticInfo diagnosticInfo, StatusCode statusCode, String string2, String string3, String string4, String string5, List<String> list) {
        this.additionalInfo = string;
        this.innerDiagnosticInfo = diagnosticInfo;
        this.innerStatusCode = statusCode;
        this.stringTable = list;
        this.locale = this.addOrGetIndex(string2);
        this.localizedText = this.addOrGetIndex(string3);
        this.namespaceUri = this.addOrGetIndex(string4);
        this.symbolicId = this.addOrGetIndex(string5);
    }

    public void setStringArray(String[] stringArray) {
        this.stringTable = null;
        this.stringArray = stringArray;
    }

    public void setStringTable(List<String> list) {
        this.stringTable = list;
        this.stringArray = null;
    }

    public List<String> getStringTable() {
        return this.stringTable;
    }

    private int addOrGetIndex(String string) {
        int n = this.stringTable.indexOf(string);
        if (n >= 0) {
            return n;
        }
        this.stringTable.add(string);
        return this.stringTable.size() - 1;
    }

    public Integer getSymbolicId() {
        return this.symbolicId;
    }

    public void setSymbolicId(Integer n) {
        this.symbolicId = n;
    }

    public String getSymbolicIdStr() {
        if (this.symbolicId == null) {
            return null;
        }
        if (this.stringArray != null) {
            return this.stringArray[this.symbolicId];
        }
        if (this.stringTable != null) {
            return this.stringTable.get(this.symbolicId);
        }
        return this.symbolicId.toString();
    }

    public void setSymbolicIdStr(String string) {
        this.symbolicId = this.addOrGetIndex(string);
    }

    public String getNamespaceUriStr() {
        if (this.namespaceUri == null) {
            return null;
        }
        if (this.stringArray != null) {
            return this.stringArray[this.namespaceUri];
        }
        if (this.stringTable != null) {
            return this.stringTable.get(this.namespaceUri);
        }
        return this.namespaceUri.toString();
    }

    public void setNamespaceUriStr(String string) {
        this.namespaceUri = this.addOrGetIndex(string);
    }

    public Integer getNamespaceUri() {
        return this.namespaceUri;
    }

    public void setNamespaceUri(Integer n) {
        this.namespaceUri = n;
    }

    public String getLocalizedTextStr() {
        if (this.localizedText == null) {
            return null;
        }
        if (this.stringArray != null) {
            return this.stringArray[this.localizedText];
        }
        if (this.stringTable != null) {
            return this.stringTable.get(this.localizedText);
        }
        return this.localizedText.toString();
    }

    public void setLocalizedTextStr(String string) {
        this.localizedText = this.addOrGetIndex(string);
    }

    public Integer getLocalizedText() {
        return this.localizedText;
    }

    public void setLocalizedText(Integer n) {
        this.localizedText = n;
    }

    public Integer getLocale() {
        return this.locale;
    }

    public void setLocale(Integer n) {
        this.locale = n;
    }

    public String getLocaleStr() {
        if (this.locale == null) {
            return null;
        }
        if (this.stringArray != null) {
            return this.stringArray[this.locale];
        }
        if (this.stringTable != null) {
            return this.stringTable.get(this.locale);
        }
        return this.locale.toString();
    }

    public void setLocaleStr(String string) {
        this.locale = this.addOrGetIndex(string);
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String string) {
        this.additionalInfo = string;
    }

    public StatusCode getInnerStatusCode() {
        return this.innerStatusCode;
    }

    public void setInnerStatusCode(StatusCode statusCode) {
        this.innerStatusCode = statusCode;
    }

    public DiagnosticInfo getInnerDiagnosticInfo() {
        return this.innerDiagnosticInfo;
    }

    public void setInnerDiagnosticInfo(DiagnosticInfo diagnosticInfo) {
        this.innerDiagnosticInfo = diagnosticInfo;
    }

    public int hashCode() {
        return ObjectUtils.hashCode(this.symbolicId) + ObjectUtils.hashCode(this.namespaceUri) * 3 + ObjectUtils.hashCode(this.localizedText) * 5 + ObjectUtils.hashCode(this.locale) * 13 + ObjectUtils.hashCode(this.additionalInfo) * 7 + ObjectUtils.hashCode(this.innerDiagnosticInfo) * 17 + ObjectUtils.hashCode(this.innerStatusCode) * 19;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DiagnosticInfo)) {
            return false;
        }
        DiagnosticInfo diagnosticInfo = (DiagnosticInfo)object;
        return ObjectUtils.objectEquals(diagnosticInfo.symbolicId, this.symbolicId) && ObjectUtils.objectEquals(diagnosticInfo.namespaceUri, this.namespaceUri) && ObjectUtils.objectEquals(diagnosticInfo.localizedText, this.localizedText) && ObjectUtils.objectEquals(diagnosticInfo.locale, this.locale) && ObjectUtils.objectEquals(diagnosticInfo.additionalInfo, this.additionalInfo) && ObjectUtils.objectEquals(diagnosticInfo.innerStatusCode, this.innerStatusCode) && ObjectUtils.objectEquals(diagnosticInfo.innerDiagnosticInfo, this.innerDiagnosticInfo);
    }

    public static void toString(DiagnosticInfo diagnosticInfo, StringBuilder stringBuilder, boolean bl, boolean bl2, boolean bl3) {
        DiagnosticInfo diagnosticInfo2;
        stringBuilder.append(bl3 ? "Inner Info: " : "Diagnostic Info: ");
        if (!bl && diagnosticInfo.getLocalizedTextStr() != null) {
            stringBuilder.append(diagnosticInfo.getLocalizedTextStr());
            stringBuilder.append(' ');
        }
        if (!bl2 && diagnosticInfo.getInnerStatusCode() != null) {
            stringBuilder.append("(");
            stringBuilder.append(diagnosticInfo.getInnerStatusCode().toString());
            stringBuilder.append(")");
        }
        stringBuilder.append('\n');
        if (diagnosticInfo.getAdditionalInfo() != null) {
            stringBuilder.append('\t');
            stringBuilder.append(diagnosticInfo.getAdditionalInfo());
            stringBuilder.append('\n');
        }
        if (diagnosticInfo.getSymbolicIdStr() != null) {
            stringBuilder.append("\tSymbolicId: " + diagnosticInfo.getSymbolicIdStr() + "\n");
        }
        if (diagnosticInfo.getNamespaceUriStr() != null) {
            stringBuilder.append("\tNamespaceUri: " + diagnosticInfo.getNamespaceUriStr() + "\n");
        }
        if ((diagnosticInfo2 = diagnosticInfo.getInnerDiagnosticInfo()) != null) {
            DiagnosticInfo.toString(diagnosticInfo2, stringBuilder, false, false, true);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        DiagnosticInfo.toString(this, stringBuilder, false, false, false);
        return stringBuilder.toString();
    }
}

