/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.builtintypes;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.core.Identifiers;

public class DateTime
implements Serializable,
Comparable<DateTime> {
    public static String DEFAULT_STR_FORMAT = "%TD %TT.%07d %TZ";
    public static String ISO_8601_STR_FORMAT = "%TF %TT.%07d %TZ";
    private static String strFormat = DEFAULT_STR_FORMAT;
    private static boolean useLocalTimeInToString = false;
    private static final long serialVersionUID = 2701845992071716850L;
    public static final NodeId ID = Identifiers.DateTime;
    private static final TimeZone UTC = TimeZone.getTimeZone("GMT");
    public static final long OffsetToGregorianCalendarZero = 116444736000000000L;
    public static final DateTime MIN_VALUE = new DateTime(0L);
    public static final DateTime MAX_VALUE = new DateTime(9999, 0, 1, 23, 59, 59, 0);
    private final long value;

    public DateTime() {
        this(GregorianCalendar.getInstance());
    }

    public DateTime(long l) {
        this.value = l;
    }

    public DateTime(Calendar calendar) {
        this.value = calendar.getTimeInMillis() * 10000L + 116444736000000000L;
    }

    public DateTime(int n, int n2, int n3, int n4, int n5, int n6, int n7, TimeZone timeZone) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2, n3, n4, n5, n6);
        ((Calendar)gregorianCalendar).setTimeZone(timeZone);
        this.value = (long)(n7 / 100) + gregorianCalendar.getTimeInMillis() * 10000L + 116444736000000000L;
    }

    public DateTime(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this(n, n2, n3, n4, n5, n6, n7, UTC);
    }

    public DateTime(int n, int n2, int n3, int n4, int n5, int n6) {
        this(n, n2, n3, n4, n5, n6, 0, UTC);
    }

    public long getValue() {
        return this.value;
    }

    public long getMilliSeconds() {
        return this.value / 10000L;
    }

    public long getTimeInMillis() {
        return (this.value - 116444736000000000L) / 10000L;
    }

    public String toString() {
        GregorianCalendar gregorianCalendar = useLocalTimeInToString ? this.getLocalCalendar() : this.getUtcCalendar();
        long l = this.value % 10000000L;
        return String.format(strFormat, gregorianCalendar, gregorianCalendar, l, gregorianCalendar);
    }

    public GregorianCalendar getUtcCalendar() {
        return this.getCalendar(UTC);
    }

    public GregorianCalendar getLocalCalendar() {
        return this.getCalendar(TimeZone.getDefault());
    }

    public GregorianCalendar getCalendar(TimeZone timeZone) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.setTimeInMillis(this.getTimeInMillis());
        return gregorianCalendar;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >> 32);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DateTime dateTime = (DateTime)object;
        return this.value == dateTime.value;
    }

    @Override
    public int compareTo(DateTime dateTime) {
        if (this.value < dateTime.value) {
            return -1;
        }
        if (this.value > dateTime.value) {
            return 1;
        }
        return 0;
    }

    public static DateTime currentTime() {
        return new DateTime();
    }

    public static DateTime parseDateTime(String string) throws ParseException {
        int n = string.length();
        if (n < 10) {
            throw new ParseException("Cannot parse DateTime from " + string + " expecting format 'yyyy-MM-dd'T'hh:mm:ssZ', for example '2011-04-13T11:47:12Z' for UTC timezone", 0);
        }
        int n2 = Integer.parseInt(string.substring(0, 4));
        int n3 = Integer.parseInt(string.substring(5, 7));
        int n4 = Integer.parseInt(string.substring(8, 10));
        int n5 = n < 13 ? 0 : Integer.parseInt(string.substring(11, 13));
        int n6 = n < 16 ? 0 : Integer.parseInt(string.substring(14, 16));
        int n7 = n < 19 ? 0 : Integer.parseInt(string.substring(17, 19));
        TimeZone timeZone = UTC;
        if (n > 19) {
            String string2 = string.substring(19);
            if (string2.charAt(0) == '+' || string2.charAt(0) == '-') {
                string2 = "GMT" + string2;
            }
            timeZone = TimeZone.getTimeZone(string2);
        }
        return new DateTime(n2, n3 - 1, n4, n5, n6, n7, 0, timeZone);
    }

    public static DateTime fromMillis(long l) {
        return new DateTime(l * 10000L + 116444736000000000L);
    }

    public static String getStrFormat() {
        return strFormat;
    }

    public static void setStrFormat(String string) {
        strFormat = string;
    }

    public static boolean isUseLocalTimeInToString() {
        return useLocalTimeInToString;
    }

    public static void setUseLocalTimeInToString(boolean bl) {
        useLocalTimeInToString = bl;
    }
}

