/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.application;

import org.opcfoundation.ua.application.Client;
import org.opcfoundation.ua.application.SessionChannel;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.EndpointDescription;
import org.opcfoundation.ua.core.SignedSoftwareCertificate;
import org.opcfoundation.ua.transport.SecureChannel;
import org.opcfoundation.ua.transport.security.Cert;
import org.opcfoundation.ua.transport.security.PrivKey;

public class Session {
    EndpointDescription endpoint;
    String name;
    NodeId sessionId;
    byte[] serverNonce;
    byte[] clientNonce;
    NodeId diagnosticsInfo;
    NodeId authenticationToken;
    double sessionTimeout;
    UnsignedInteger maxRequestMessageSize;
    SignedSoftwareCertificate[] serverSoftwareCertificates;
    Cert serverCertificate;
    Cert clientCertificate;
    PrivKey clientPrivateKey;
    PrivKey serverPrivateKey;

    Session() {
    }

    public SessionChannel createSessionChannel(SecureChannel secureChannel, Client client) {
        return new SessionChannel(client, this, secureChannel);
    }

    public EndpointDescription getEndpoint() {
        return this.endpoint;
    }

    public byte[] getServerNonce() {
        return this.serverNonce;
    }

    public NodeId getDiagnosticsInfo() {
        return this.diagnosticsInfo;
    }

    public NodeId getAuthenticationToken() {
        return this.authenticationToken;
    }

    public double getSessionTimeout() {
        return this.sessionTimeout;
    }

    public UnsignedInteger getMaxRequestMessageSize() {
        return this.maxRequestMessageSize;
    }

    public SignedSoftwareCertificate[] getServerSoftwareCertificates() {
        return this.serverSoftwareCertificates;
    }

    public Cert getServerCertificate() {
        return this.serverCertificate;
    }

    public String getName() {
        return this.name;
    }

    public NodeId getSessionId() {
        return this.sessionId;
    }

    public void setName(String string) {
        this.name = string;
    }

    public byte[] getClientNonce() {
        return this.clientNonce;
    }

    public Cert getClientCertificate() {
        return this.clientCertificate;
    }

    public PrivKey getClientPrivateKey() {
        return this.clientPrivateKey;
    }

    public PrivKey getServerPrivateKey() {
        return this.serverPrivateKey;
    }
}

