/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.application;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opcfoundation.ua.application.AbstractServiceHandler;
import org.opcfoundation.ua.application.ServiceHandler;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.common.ServiceFaultException;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.ServiceFault;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.encoding.IEncodeable;
import org.opcfoundation.ua.transport.endpoint.EndpointServiceRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceHandlerComposition
implements ServiceHandler {
    static Logger log = LoggerFactory.getLogger(ServiceHandlerComposition.class);
    Map<Class<? extends IEncodeable>, ServiceHandler> handlerMap = new HashMap<Class<? extends IEncodeable>, ServiceHandler>();
    Map<Class<? extends IEncodeable>, Object> handlerMap2 = new HashMap<Class<? extends IEncodeable>, Object>();
    ServiceHandler[] handlers;

    public static final ServiceHandler of(Object ... objectArray) {
        if (objectArray.length == 1 && objectArray[0] instanceof ServiceHandler) {
            return (ServiceHandler)objectArray[0];
        }
        ServiceHandlerComposition serviceHandlerComposition = new ServiceHandlerComposition();
        for (Object object : objectArray) {
            serviceHandlerComposition.add(object);
        }
        return serviceHandlerComposition;
    }

    public void add(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("null");
        }
        if (object instanceof ServiceHandler) {
            ServiceHandler serviceHandler = (ServiceHandler)object;
            ArrayList<Class<? extends IEncodeable>> arrayList = new ArrayList<Class<? extends IEncodeable>>();
            serviceHandler.getSupportedServices(arrayList);
            for (Class<? extends IEncodeable> clazz : arrayList) {
                ServiceHandler serviceHandler2 = this.handlerMap.get(clazz);
                if (serviceHandler2 != null && serviceHandler != serviceHandler2) {
                    throw new RuntimeException("ServiceHandlerComposition already handles " + clazz);
                }
                this.handlerMap.put(clazz, serviceHandler);
                this.handlerMap2.put(clazz, object);
            }
        } else {
            ServiceHandlerComposition.readWithReflection(object, this);
        }
        this.handlers = this.handlerMap.values().toArray(new ServiceHandler[0]);
    }

    public ServiceHandler[] getServiceHandlers() {
        return this.handlers;
    }

    @Override
    public void serve(EndpointServiceRequest<?, ?> endpointServiceRequest) throws ServiceResultException {
        if (log.isDebugEnabled()) {
            log.debug("serve: {}", (Object)endpointServiceRequest.getRequest().getClass().getSimpleName());
            log.debug("serve: handlerMap={}", (Object)Arrays.toString(this.handlerMap.keySet().toArray(new Class[0])));
        }
        ServiceHandler serviceHandler = this.handlerMap.get(endpointServiceRequest.getRequest().getClass());
        log.debug("serve: handler={}", (Object)serviceHandler);
        if (serviceHandler == null) {
            log.info("Service {} is not supported", (Object)endpointServiceRequest.getRequest().getClass().getSimpleName());
            this.sendErrorResponse(endpointServiceRequest, new ServiceResultException(StatusCodes.Bad_ServiceUnsupported, endpointServiceRequest.getRequest().getClass().getSimpleName()));
            return;
        }
        try {
            serviceHandler.serve(endpointServiceRequest);
        }
        catch (ServiceResultException serviceResultException) {
            log.error("While handling " + endpointServiceRequest.getRequest(), (Throwable)serviceResultException);
            this.sendErrorResponse(endpointServiceRequest, serviceResultException);
        }
    }

    private void sendErrorResponse(EndpointServiceRequest<?, ?> endpointServiceRequest, ServiceResultException serviceResultException) {
        ServiceFault serviceFault = ServiceFault.toServiceFault(serviceResultException);
        endpointServiceRequest.sendFault(serviceFault);
    }

    @Override
    public boolean supportsService(Class<? extends IEncodeable> clazz) {
        return this.handlerMap.containsKey(clazz);
    }

    @Override
    public void getSupportedServices(Collection<Class<? extends IEncodeable>> collection) {
        collection.addAll(this.handlerMap.keySet());
    }

    public <T> T getServiceHandlerByService(Class<? extends ServiceRequest> clazz) {
        return (T)this.handlerMap2.get(clazz);
    }

    public static void readWithReflection(final Object object, ServiceHandlerComposition serviceHandlerComposition) {
        Class<?> clazz = object.getClass();
        for (final Method method : clazz.getMethods()) {
            ParameterizedType parameterizedType;
            Type[] typeArray;
            Class<?>[] classArray;
            if (method.getReturnType() != Void.TYPE || (classArray = method.getParameterTypes()) == null || classArray.length != 1 || !EndpointServiceRequest.class.isAssignableFrom(classArray[0]) || (typeArray = method.getGenericParameterTypes()) == null || typeArray.length != 1 || !(typeArray[0] instanceof ParameterizedType) || (typeArray = (parameterizedType = (ParameterizedType)typeArray[0]).getActualTypeArguments()) == null || typeArray.length != 2 || typeArray[0] == null || typeArray[1] == null || !(typeArray[0] instanceof Class) || !IEncodeable.class.isAssignableFrom((Class)typeArray[0]) || !(typeArray[1] instanceof Class) || !IEncodeable.class.isAssignableFrom((Class)typeArray[1])) continue;
            Class clazz2 = (Class)typeArray[0];
            method.setAccessible(true);
            if (!method.isAccessible()) {
                throw new Error(clazz.getName() + "." + method.getName() + " is not accessible to be used as a service handler");
            }
            AbstractServiceHandler abstractServiceHandler = new AbstractServiceHandler(clazz2){

                @Override
                public void serve(EndpointServiceRequest<?, ?> endpointServiceRequest) throws ServiceResultException {
                    try {
                        method.invoke(object, endpointServiceRequest);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new Error(illegalArgumentException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new Error(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Throwable throwable;
                        Throwable throwable2 = throwable = invocationTargetException.getCause() != null ? invocationTargetException.getCause() : invocationTargetException;
                        if (throwable instanceof ServiceResultException) {
                            throw (ServiceResultException)throwable;
                        }
                        throw new ServiceFaultException(throwable);
                    }
                }
            };
            serviceHandlerComposition.add(abstractServiceHandler);
            serviceHandlerComposition.handlerMap2.put(clazz2, object);
        }
    }
}

