/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.application;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opcfoundation.ua.application.Server;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.common.ServiceFaultException;
import org.opcfoundation.ua.core.EndpointDescription;
import org.opcfoundation.ua.core.GetEndpointsRequest;
import org.opcfoundation.ua.core.GetEndpointsResponse;
import org.opcfoundation.ua.core.ResponseHeader;
import org.opcfoundation.ua.transport.endpoint.EndpointBindingCollection;
import org.opcfoundation.ua.transport.endpoint.EndpointServiceRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointDiscoveryService {
    EndpointBindingCollection endpointBindings;
    private static Logger logger = LoggerFactory.getLogger(EndpointDiscoveryService.class);

    public EndpointDiscoveryService(EndpointBindingCollection endpointBindingCollection) {
        this.endpointBindings = endpointBindingCollection;
    }

    public void setEndpointBindingCollection(EndpointBindingCollection endpointBindingCollection) {
        this.endpointBindings = endpointBindingCollection;
    }

    public void onGetEndpoints(EndpointServiceRequest<GetEndpointsRequest, GetEndpointsResponse> endpointServiceRequest) throws ServiceFaultException {
        EndpointDescription[] endpointDescriptionArray;
        SocketAddress socketAddress = endpointServiceRequest.getChannel().getConnection().getLocalAddress();
        logger.debug("onGetEndpoints: requestAddress={}", (Object)socketAddress);
        logger.trace("onGetEndpoints: Request={}", (Object)endpointServiceRequest.getRequest());
        GetEndpointsResponse getEndpointsResponse = new GetEndpointsResponse();
        String string = this.trimUrl(endpointServiceRequest.getRequest().getEndpointUrl());
        String string2 = this.getUrlHost(string);
        String string3 = this.getUrlServerName(string);
        Object[] objectArray = endpointServiceRequest.getRequest().getProfileUris();
        logger.debug("onGetEndpoints: requestUrl={}", (Object)string);
        logger.debug("onGetEndpoints: host={}", (Object)string2);
        logger.debug("onGetEndpoints: serverName={}", (Object)string3);
        logger.debug("onGetEndpoints: profileUris={}", (Object)Arrays.toString(objectArray));
        List<Object> list = objectArray == null ? new ArrayList(0) : Arrays.asList(objectArray);
        ArrayList<EndpointDescription> arrayList = new ArrayList<EndpointDescription>();
        List<Server> list2 = this.endpointBindings.getServiceServers();
        for (Server server : list2) {
            for (EndpointDescription endpointDescription : endpointDescriptionArray = server.getEndpointDescriptions(socketAddress)) {
                logger.debug("ed.TransportProfileUri={}", (Object)endpointDescription.getTransportProfileUri());
                if (!list.isEmpty() && !list.contains(endpointDescription.getTransportProfileUri())) continue;
                logger.debug("ed.EndpointUrl={}", (Object)endpointDescription.getEndpointUrl());
                String string4 = this.getUrlHost(endpointDescription.getEndpointUrl());
                String string5 = this.getUrlServerName(endpointDescription.getEndpointUrl());
                if (!string.isEmpty() && (!string4.equals(string2) || !string3.isEmpty() && !string5.equals(string3))) continue;
                arrayList.add(endpointDescription);
            }
        }
        if (arrayList.isEmpty()) {
            logger.debug("onGetEndpoints: no matching endpoints for requested hostname, checking all with the same serverName");
            for (Server server : list2) {
                for (EndpointDescription endpointDescription : endpointDescriptionArray = server.getEndpointDescriptions()) {
                    if (!list.isEmpty() && !list.contains(endpointDescription.getTransportProfileUri()) || !string3.isEmpty() && !string3.equals(this.getUrlServerName(endpointDescription.getEndpointUrl()))) continue;
                    logger.debug("ed.EndpointUrl={}", (Object)endpointDescription.getEndpointUrl());
                    arrayList.add(endpointDescription);
                }
            }
        }
        if (arrayList.isEmpty()) {
            logger.debug("onGetEndpoints: no matching endpoints ignoring host, adding all");
            for (Server server : list2) {
                for (EndpointDescription endpointDescription : endpointDescriptionArray = server.getEndpointDescriptions()) {
                    if (!list.isEmpty() && !list.contains(endpointDescription.getTransportProfileUri())) continue;
                    logger.debug("ed.EndpointUrl={}", (Object)endpointDescription.getEndpointUrl());
                    arrayList.add(endpointDescription);
                }
            }
        }
        logger.trace("onGetEndpoints: list={}", arrayList);
        getEndpointsResponse.setEndpoints(arrayList.toArray(new EndpointDescription[0]));
        ResponseHeader responseHeader = new ResponseHeader(DateTime.currentTime(), endpointServiceRequest.getRequest().getRequestHeader().getRequestHandle(), null, null, null, null);
        getEndpointsResponse.setResponseHeader(responseHeader);
        endpointServiceRequest.sendResponse(getEndpointsResponse);
    }

    public EndpointBindingCollection getEndpointCollection() {
        return this.endpointBindings;
    }

    private String trimUrl(String string) {
        if (string == null) {
            return "";
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private String getUrlHost(String string) {
        if (string == null) {
            return "";
        }
        int n = string.indexOf("://") + 3;
        if (n < 3) {
            return "";
        }
        int n2 = string.indexOf(":", n);
        if (n2 < n) {
            n2 = string.indexOf("/", n);
        }
        String string2 = n2 > n ? string.substring(n, n2) : string.substring(n);
        return string2.toLowerCase();
    }

    private String getUrlServerName(String string) {
        if (string == null) {
            return "";
        }
        int n = string.indexOf("://") + 3;
        if ((n = string.indexOf("/", n) + 1) < 1) {
            return "";
        }
        return string.substring(n);
    }
}

