/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.application;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.common.NamespaceTable;
import org.opcfoundation.ua.common.ServerTable;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.ApplicationDescription;
import org.opcfoundation.ua.core.SignedSoftwareCertificate;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.transport.EndpointServer;
import org.opcfoundation.ua.transport.https.HttpsServer;
import org.opcfoundation.ua.transport.https.HttpsSettings;
import org.opcfoundation.ua.transport.security.CertificateValidator;
import org.opcfoundation.ua.transport.security.KeyPair;
import org.opcfoundation.ua.transport.tcp.io.OpcTcpSettings;
import org.opcfoundation.ua.transport.tcp.nio.OpcTcpServer;
import org.opcfoundation.ua.utils.CryptoUtil;
import org.opcfoundation.ua.utils.StackUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application {
    private static final Logger logger = LoggerFactory.getLogger(Application.class);
    ApplicationDescription applicationDescription = new ApplicationDescription();
    List<KeyPair> applicationInstanceCertificates = new CopyOnWriteArrayList<KeyPair>();
    List<SignedSoftwareCertificate> softwareCertificates = new CopyOnWriteArrayList<SignedSoftwareCertificate>();
    List<Locale> locales = new CopyOnWriteArrayList<Locale>();
    HttpsSettings httpsSettings = new HttpsSettings();
    OpcTcpSettings opctcpSettings = new OpcTcpSettings();
    HttpsServer httpsServer;
    OpcTcpServer opctcpServer;
    private EncoderContext encoderContext = new EncoderContext(new NamespaceTable(), new ServerTable(), StackUtils.getDefaultSerializer());

    public Application() {
        String string = "";
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.applicationDescription.setApplicationUri("urn:" + string + ":" + UUID.randomUUID());
        this.getOpctcpSettings().setCertificateValidator(CertificateValidator.ALLOW_ALL);
        this.getHttpsSettings().setCertificateValidator(CertificateValidator.ALLOW_ALL);
    }

    public EncoderContext getEncoderContext() {
        return this.encoderContext;
    }

    public HttpsSettings getHttpsSettings() {
        return this.httpsSettings;
    }

    public void setHttpsSettings(HttpsSettings httpsSettings) {
        this.httpsSettings = httpsSettings;
    }

    public synchronized EndpointServer getOrCreateEndpointServer(String string) throws ServiceResultException {
        if (string.equals("opc.tcp")) {
            return this.getOrCreateOpcTcpServer();
        }
        if (string.equals("http") || string.equals("https")) {
            return this.getOrCreateHttpsServer();
        }
        throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Cannot find EndpointServer for scheme " + string);
    }

    public synchronized HttpsServer getOrCreateHttpsServer() throws ServiceResultException {
        if (this.httpsServer == null) {
            this.httpsServer = new HttpsServer(this);
        }
        return this.httpsServer;
    }

    public synchronized OpcTcpServer getOrCreateOpcTcpServer() throws ServiceResultException {
        if (this.opctcpServer == null) {
            this.opctcpServer = new OpcTcpServer(this);
        }
        return this.opctcpServer;
    }

    public OpcTcpSettings getOpctcpSettings() {
        return this.opctcpSettings;
    }

    public void setOpctcpSettings(OpcTcpSettings opcTcpSettings) {
        this.opctcpSettings = opcTcpSettings;
    }

    public ApplicationDescription getApplicationDescription() {
        return this.applicationDescription;
    }

    public SignedSoftwareCertificate[] getSoftwareCertificates() {
        return this.softwareCertificates.toArray(new SignedSoftwareCertificate[this.softwareCertificates.size()]);
    }

    public void addSoftwareCertificate(SignedSoftwareCertificate signedSoftwareCertificate) {
        if (signedSoftwareCertificate == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.softwareCertificates.add(signedSoftwareCertificate);
    }

    public KeyPair[] getApplicationInstanceCertificates() {
        return this.applicationInstanceCertificates.toArray(new KeyPair[this.applicationInstanceCertificates.size()]);
    }

    public void addApplicationInstanceCertificate(KeyPair keyPair) {
        if (keyPair == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.applicationInstanceCertificates.add(keyPair);
    }

    public void removeApplicationInstanceCertificate(KeyPair keyPair) {
        this.applicationInstanceCertificates.remove(keyPair);
    }

    public KeyPair getApplicationInstanceCertificate(byte[] byArray) {
        logger.debug("getApplicationInstanceCertificate: expected={}", (Object)CryptoUtil.toHex(byArray));
        if (byArray != null) {
            int n = 0;
            for (KeyPair keyPair : this.applicationInstanceCertificates) {
                byte[] byArray2 = keyPair.getCertificate().getEncodedThumbprint();
                logger.debug("getApplicationInstanceCertificate: cert[{}]={}", (Object)n++, (Object)CryptoUtil.toHex(byArray2));
                if (!Arrays.equals(byArray2, byArray)) continue;
                return keyPair;
            }
        }
        return null;
    }

    public KeyPair getApplicationInstanceCertificate() {
        int n = this.applicationInstanceCertificates.size() - 1;
        if (n < 0) {
            return null;
        }
        return this.applicationInstanceCertificates.get(n);
    }

    public String getApplicationUri() {
        return this.applicationDescription.getApplicationUri();
    }

    public void setApplicationUri(String string) {
        this.applicationDescription.setApplicationUri(string);
    }

    public void setApplicationName(LocalizedText localizedText) {
        this.applicationDescription.setApplicationName(localizedText);
    }

    public String getProductUri() {
        return this.applicationDescription.getProductUri();
    }

    public void setProductUri(String string) {
        this.applicationDescription.setProductUri(string);
    }

    public void addLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.locales.add(locale);
    }

    public void removeLocale(Locale locale) {
        this.locales.remove(locale);
    }

    public Locale[] getLocales() {
        return this.locales.toArray(new Locale[0]);
    }

    public String[] getLocaleIds() {
        ArrayList<String> arrayList = new ArrayList<String>(this.locales.size());
        for (Locale locale : this.locales) {
            arrayList.add(LocalizedText.toLocaleId(locale));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void close() {
        if (this.httpsServer != null) {
            this.httpsServer.close();
            this.httpsServer = null;
        }
        if (this.opctcpServer != null) {
            this.opctcpServer.close();
            this.opctcpServer = null;
        }
    }
}

