/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.SaveDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;

public class FITS_Writer
implements PlugIn {
    private int numCards = 0;
    private Calibration cal;
    private boolean unsigned16 = false;
    private double bZero = 0.0;
    private double bScale = 1.0;

    @Override
    public void run(String path) {
        ImagePlus imp = IJ.getImage();
        ImageProcessor ip = imp.getProcessor();
        int numImages = imp.getImageStackSize();
        int bitDepth = imp.getBitDepth();
        if (bitDepth == 24) {
            IJ.error("RGB images are not supported");
            return;
        }
        if (path == null || path.trim().length() == 0) {
            String title = "image.fits";
            SaveDialog sd = new SaveDialog("Write FITS image", title, ".fits");
            path = sd.getDirectory() + sd.getFileName();
        }
        File f = new File(path);
        String directory = f.getParent() + File.separator;
        String name = f.getName();
        if (f.exists()) {
            f.delete();
        }
        int numBytes = 0;
        this.cal = imp.getCalibration();
        boolean bl = this.unsigned16 = bitDepth == 16 && this.cal.getFunction() == 20 && this.cal.getCoefficients() == null;
        if (bitDepth == 8) {
            numBytes = 1;
            if (this.cal.getFunction() != 20 && this.cal.getCoefficients() != null) {
                this.bZero = this.cal.getCoefficients()[0];
                if (this.cal.getCoefficients()[1] != 0.0) {
                    this.bScale = this.cal.getCoefficients()[1];
                }
            }
        } else if (ip instanceof ShortProcessor) {
            numBytes = 2;
            if (this.unsigned16) {
                this.bZero = 32768.0;
                this.bScale = 1.0;
            } else {
                if (this.cal.getCoefficients()[1] != 0.0) {
                    this.bScale = this.cal.getCoefficients()[1];
                }
                this.bZero = this.cal.getCoefficients()[0] + 32768.0 * this.bScale;
            }
        } else if (ip instanceof FloatProcessor) {
            numBytes = 4;
            this.bZero = 0.0;
            this.bScale = 1.0;
        }
        int fillerLength = 2880 - numBytes * imp.getWidth() * imp.getHeight() % 2880;
        String[] hdr = FITS_Writer.getHeader(imp);
        this.createHeader(hdr, path, ip, numBytes);
        this.writeData(path, ip);
        char[] endFiller = new char[fillerLength];
        this.appendFile(endFiller, path);
    }

    char[] writeCard(String title, String value, String comment) {
        char[] card = new char[80];
        for (int i = 0; i < 80; ++i) {
            card[i] = 32;
        }
        this.s2ch(title, card, 0);
        card[8] = 61;
        this.s2ch(value, card, 10);
        card[31] = 47;
        card[32] = 32;
        this.s2ch(comment, card, 33);
        ++this.numCards;
        return card;
    }

    void writeCard(char[] line, String path) {
        this.appendFile(line, path);
        ++this.numCards;
    }

    void s2ch(String str, char[] ch, int offset) {
        int j = 0;
        for (int i = offset; i < 80 && i < str.length() + offset; ++i) {
            ch[i] = str.charAt(j++);
        }
    }

    void appendFile(char[] line, String path) {
        try {
            FileWriter output = new FileWriter(path, true);
            output.write(line);
            output.close();
        }
        catch (IOException e) {
            IJ.showStatus("Error writing file!");
            return;
        }
    }

    void writeData(String path, ImageProcessor ip) {
        int w = ip.getWidth();
        int h = ip.getHeight();
        if (ip instanceof ByteProcessor) {
            byte[] pixels = (byte[])ip.getPixels();
            try {
                DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path, true)));
                for (int i = h - 1; i >= 0; --i) {
                    for (int j = i * w; j < w * (i + 1); ++j) {
                        dos.writeByte(pixels[j]);
                    }
                }
                dos.close();
            }
            catch (IOException e) {
                IJ.showStatus("Error writing file!");
                return;
            }
        }
        if (ip instanceof ShortProcessor) {
            short[] pixels = (short[])ip.getPixels();
            try {
                DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path, true)));
                for (int i = h - 1; i >= 0; --i) {
                    for (int j = i * w; j < w * (i + 1); ++j) {
                        dos.writeShort(pixels[j] ^ 0x8000);
                    }
                }
                dos.close();
            }
            catch (IOException e) {
                IJ.showStatus("Error writing file!");
                return;
            }
        }
        if (ip instanceof FloatProcessor) {
            float[] pixels = (float[])ip.getPixels();
            try {
                DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path, true)));
                for (int i = h - 1; i >= 0; --i) {
                    for (int j = i * w; j < w * (i + 1); ++j) {
                        dos.writeFloat(pixels[j]);
                    }
                }
                dos.close();
            }
            catch (IOException e) {
                IJ.showStatus("Error writing file!");
                return;
            }
        }
    }

    public static String[] getHeader(ImagePlus img) {
        String s;
        int iend;
        int istart;
        String content = null;
        int depth = img.getStackSize();
        if (depth == 1) {
            Properties props = img.getProperties();
            if (props == null) {
                return null;
            }
            content = props.getProperty("Info");
        } else if (depth > 1) {
            int slice = img.getCurrentSlice();
            ImageStack stack = img.getStack();
            content = stack.getSliceLabel(slice);
            if (content == null) {
                Properties props = img.getProperties();
                if (props == null) {
                    return null;
                }
                content = props.getProperty("Info");
            }
        }
        if (content == null) {
            return null;
        }
        String[] lines = content.split("\n");
        for (istart = 0; istart < lines.length && !lines[istart].startsWith("SIMPLE"); ++istart) {
        }
        if (istart == lines.length) {
            return null;
        }
        for (iend = istart + 1; iend < lines.length && !(s = lines[iend].trim()).equals("END") && !s.startsWith("END "); ++iend) {
        }
        if (iend >= lines.length) {
            return null;
        }
        int l = iend - istart + 1;
        String header = "";
        for (int i = 0; i < l; ++i) {
            header = header + lines[istart + i] + "\n";
        }
        return header.split("\n");
    }

    char[] eighty(String s) {
        char[] c = new char[80];
        int l = s.length();
        for (int i = 0; i < l && i < 80; ++i) {
            c[i] = s.charAt(i);
        }
        if (l < 80) {
            while (l < 80) {
                c[l] = 32;
                ++l;
            }
        }
        return c;
    }

    void createHeader(String[] hdr, String path, ImageProcessor ip, int numBytes) {
        String bitperpix = "";
        int imw = ip.getWidth();
        int imh = ip.getHeight();
        String wbuf = "               ";
        String hbuf = "               ";
        if (imw < 10000) {
            wbuf = wbuf + " ";
        }
        if (imw < 1000) {
            wbuf = wbuf + " ";
        }
        if (imw < 100) {
            wbuf = wbuf + " ";
        }
        if (imw < 10) {
            wbuf = wbuf + " ";
        }
        if (imh < 10000) {
            hbuf = hbuf + " ";
        }
        if (imh < 1000) {
            hbuf = hbuf + " ";
        }
        if (imh < 100) {
            hbuf = hbuf + " ";
        }
        if (imh < 10) {
            hbuf = hbuf + " ";
        }
        if (numBytes == 2) {
            bitperpix = "                  16";
        } else if (numBytes == 4) {
            bitperpix = "                 -32";
        } else if (numBytes == 1) {
            bitperpix = "                   8";
        }
        this.appendFile(this.writeCard("SIMPLE", "                   T", "Created by ImageJ FITS_Writer"), path);
        this.appendFile(this.writeCard("BITPIX", bitperpix, "number of bits per data pixel"), path);
        this.appendFile(this.writeCard("NAXIS", "                   2", "number of data axes"), path);
        this.appendFile(this.writeCard("NAXIS1", wbuf + imw, "length of data axis 1"), path);
        this.appendFile(this.writeCard("NAXIS2", hbuf + imh, "length of data axis 2"), path);
        if (this.bZero != 0.0 || this.bScale != 1.0) {
            this.appendFile(this.writeCard("BZERO", "" + this.bZero, "data range offset"), path);
            this.appendFile(this.writeCard("BSCALE", "" + this.bScale, "scaling factor"), path);
        }
        if (hdr != null) {
            for (int i = 0; i < hdr.length; ++i) {
                String s = hdr[i];
                char[] card = this.eighty(s);
                if (s.startsWith("SIMPLE") || s.startsWith("BITPIX") || s.startsWith("NAXIS") || s.startsWith("BZERO") || s.startsWith("BSCALE") || s.startsWith("END") || s.trim().length() <= 1) continue;
                this.writeCard(card, path);
            }
        }
        int fillerSize = 2880 - (this.numCards * 80 + 3) % 2880;
        char[] end = new char[]{'E', 'N', 'D'};
        char[] filler = new char[fillerSize];
        for (int i = 0; i < fillerSize; ++i) {
            filler[i] = 32;
        }
        this.appendFile(end, path);
        this.appendFile(filler, path);
    }
}

