/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.FHT;
import ij.process.ImageProcessor;

public class FFTMath
implements PlugIn {
    private static final int CONJUGATE_MULTIPLY = 0;
    private static final int MULTIPLY = 1;
    private static final int DIVIDE = 2;
    private static String[] ops = new String[]{"Correlate", "Convolve", "Deconvolve"};
    private static int index1;
    private static int index2;
    private static int operation;
    private static boolean doInverse;
    private static String title;
    private ImagePlus imp1;
    private ImagePlus imp2;

    @Override
    public void run(String arg) {
        if (this.showDialog()) {
            this.doMath(this.imp1, this.imp2);
        }
    }

    public boolean showDialog() {
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            IJ.noImage();
            return false;
        }
        int nGoodImages = 0;
        for (int i = 0; i < wList.length; ++i) {
            ImagePlus imp = WindowManager.getImage(wList[i]);
            if (imp == null || imp.getWidth() != imp.getHeight() || !FHT.isPowerOf2(imp.getWidth())) {
                wList[i] = 0;
                continue;
            }
            ++nGoodImages;
        }
        if (nGoodImages == 0) {
            IJ.error("FFT Math", "Images must be a power of 2 size (256x256, 512x512, etc.)");
            return false;
        }
        int[] wList2 = new int[nGoodImages];
        String[] titles = new String[nGoodImages];
        int i2 = 0;
        for (int i = 0; i < wList.length; ++i) {
            if (wList[i] == 0) continue;
            wList2[i2] = wList[i];
            ImagePlus imp = WindowManager.getImage(wList2[i2]);
            titles[i2] = imp != null ? imp.getTitle() : "";
            ++i2;
        }
        if (index1 >= wList2.length) {
            index1 = 0;
        }
        if (index2 >= wList2.length) {
            index2 = 0;
        }
        if (WindowManager.getImage(title) != null) {
            title = WindowManager.getUniqueName(title);
        }
        GenericDialog gd = new GenericDialog("FFT Math");
        gd.addChoice("Image1: ", titles, titles[index1]);
        gd.addChoice("Operation:", ops, ops[operation]);
        gd.addChoice("Image2: ", titles, titles[index2]);
        gd.addStringField("Result:", title);
        gd.addCheckbox("Do inverse transform", doInverse);
        gd.addHelp("http://imagej.nih.gov/ij/docs/menus/process.html#fft-math");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        index1 = gd.getNextChoiceIndex();
        operation = gd.getNextChoiceIndex();
        index2 = gd.getNextChoiceIndex();
        title = gd.getNextString();
        doInverse = gd.getNextBoolean();
        this.imp1 = WindowManager.getImage(wList2[index1]);
        this.imp2 = WindowManager.getImage(wList2[index2]);
        return true;
    }

    public void doMath(ImagePlus imp1, ImagePlus imp2) {
        Calibration cal3;
        FHT h1;
        FHT h2 = null;
        ImageProcessor fht1 = (ImageProcessor)imp1.getProperty("FHT");
        if (fht1 != null) {
            h1 = new FHT(fht1);
        } else {
            IJ.showStatus("Converting to float");
            ImageProcessor ip1 = imp1.getProcessor();
            h1 = new FHT(ip1);
        }
        ImageProcessor fht2 = (ImageProcessor)imp2.getProperty("FHT");
        if (fht2 != null) {
            h2 = new FHT(fht2);
        } else {
            ImageProcessor ip2 = imp2.getProcessor();
            if (imp2 != imp1) {
                h2 = new FHT(ip2);
            }
        }
        if (!h1.powerOf2Size()) {
            IJ.error("FFT Math", "Images must be a power of 2 size (256x256, 512x512, etc.)");
            return;
        }
        if (imp1.getWidth() != imp2.getWidth()) {
            IJ.error("FFT Math", "Images must be the same size");
            return;
        }
        if (fht1 == null) {
            IJ.showStatus("Transform image1");
            h1.transform();
        }
        if (fht2 == null) {
            if (h2 == null) {
                h2 = new FHT(h1.duplicate());
            } else {
                IJ.showStatus("Transform image2");
                h2.transform();
            }
        }
        FHT result = null;
        switch (operation) {
            case 0: {
                IJ.showStatus("Complex conjugate multiply");
                result = h1.conjugateMultiply(h2);
                break;
            }
            case 1: {
                IJ.showStatus("Fourier domain multiply");
                result = h1.multiply(h2);
                break;
            }
            case 2: {
                IJ.showStatus("Fourier domain divide");
                result = h1.divide(h2);
            }
        }
        ImagePlus imp3 = null;
        if (doInverse) {
            IJ.showStatus("Inverse transform");
            result.inverseTransform();
            IJ.showStatus("Swap quadrants");
            result.swapQuadrants();
            IJ.showStatus("Display image");
            result.resetMinAndMax();
            imp3 = new ImagePlus(title, result);
        } else {
            IJ.showStatus("Power spectrum");
            ImageProcessor ps = result.getPowerSpectrum();
            imp3 = new ImagePlus(title, ps.convertToFloat());
            result.quadrantSwapNeeded = true;
            imp3.setProperty("FHT", result);
        }
        Calibration cal1 = imp1.getCalibration();
        Calibration cal2 = imp2.getCalibration();
        Calibration calibration = cal3 = cal1.scaled() ? cal1 : cal2;
        if (cal1.scaled() && cal2.scaled() && !cal1.equals(cal2)) {
            cal3 = null;
        }
        imp3.setCalibration(cal3);
        cal3 = imp3.getCalibration();
        cal3.disableDensityCalibration();
        imp3.show();
        IJ.showProgress(1.0);
    }

    static {
        operation = 0;
        doInverse = true;
        title = "Result";
    }
}

