/*
 * Decompiled with CFR 0.152.
 */
package ij.measure;

import ij.IJ;
import ij.gui.GenericDialog;
import ij.gui.Plot;
import ij.macro.Interpreter;
import ij.macro.Program;
import ij.macro.Tokenizer;
import ij.measure.Minimizer;
import ij.measure.UserFunction;
import ij.util.IJMath;
import ij.util.Tools;
import java.awt.Color;
import java.util.Hashtable;

public class CurveFitter
implements UserFunction {
    public static final int STRAIGHT_LINE = 0;
    public static final int POLY2 = 1;
    public static final int POLY3 = 2;
    public static final int POLY4 = 3;
    public static final int EXPONENTIAL = 4;
    public static final int POWER = 5;
    public static final int LOG = 6;
    public static final int RODBARD = 7;
    public static final int GAMMA_VARIATE = 8;
    public static final int LOG2 = 9;
    public static final int RODBARD2 = 10;
    public static final int EXP_WITH_OFFSET = 11;
    public static final int GAUSSIAN = 12;
    public static final int EXP_RECOVERY = 13;
    public static final int INV_RODBARD = 14;
    public static final int EXP_REGRESSION = 15;
    public static final int POWER_REGRESSION = 16;
    public static final int POLY5 = 17;
    public static final int POLY6 = 18;
    public static final int POLY7 = 19;
    public static final int POLY8 = 20;
    public static final int GAUSSIAN_NOOFFSET = 21;
    public static final int EXP_RECOVERY_NOOFFSET = 22;
    public static final int CHAPMAN = 23;
    public static final int ERF = 24;
    public static final int[] sortedTypes = new int[]{0, 1, 2, 3, 17, 18, 19, 20, 5, 16, 4, 15, 11, 13, 22, 6, 9, 12, 21, 24, 7, 10, 14, 8, 23};
    public static final String[] fitList = new String[]{"Straight Line", "2nd Degree Polynomial", "3rd Degree Polynomial", "4th Degree Polynomial", "Exponential", "Power", "Log", "Rodbard", "Gamma Variate", "y = a+b*ln(x-c)", "Rodbard (NIH Image)", "Exponential with Offset", "Gaussian", "Exponential Recovery", "Inverse Rodbard", "Exponential (linear regression)", "Power (linear regression)", "5th Degree Polynomial", "6th Degree Polynomial", "7th Degree Polynomial", "8th Degree Polynomial", "Gaussian (no offset)", "Exponential Recovery (no offset)", "Chapman-Richards", "Error Function"};
    public static final String[] fList = new String[]{"y = a+bx", "y = a+bx+cx^2", "y = a+bx+cx^2+dx^3", "y = a+bx+cx^2+dx^3+ex^4", "y = a*exp(bx)", "y = a*x^b", "y = a*ln(bx)", "y = d+(a-d)/(1+(x/c)^b)", "y = b*(x-a)^c*exp(-(x-a)/d)", "y = a+b*ln(x-c)", "x = d+(a-d)/(1+(y/c)^b) [y = c*((x-a)/(d-x))^(1/b)]", "y = a*exp(-bx) + c", "y = a + (b-a)*exp(-(x-c)*(x-c)/(2*d*d))", "y = a*(1-exp(-b*x)) + c", "y = c*((x-a)/(d-x))^(1/b)", "y = a*exp(bx)", "y = a*x^b", "y = a+bx+cx^2+dx^3+ex^4+fx^5", "y = a+bx+cx^2+dx^3+ex^4+fx^5+gx^6", "y = a+bx+cx^2+dx^3+ex^4+fx^5+gx^6+hx^7", "y = a+bx+cx^2+dx^3+ex^4+fx^5+gx^6+hx^7+ix^8", "y = a*exp(-(x-b)*(x-b)/(2*c*c)))", "y = a*(1-exp(-b*x))", "y = a*(1-exp(-b*x))^c", "y = a+b*erf((x-c)/d)"};
    public static final String[] fMacro = new String[]{"y = a+x*b", "y = a+x*(b+x*c)", "y = a+x*(b+x*(c+x*d))", "y = a+x*(b+x*(c+x*(d+x*e)))", "y = a*Math.exp(b*x)", "y = a*Math.pow(x,b)", "y = a*Math.log(b*x)", "y = d+(a-d)/(1+Math.pow(x/c,b))", "y = b*Math.pow(x-a,c)*Math.exp(-(x-a)/d)", "y = a+b*Math.log(x-c)", "y = c*Math.pow((x-a)/(d-x),1/b)", "y = a*Math.exp(-b*x)+c", "y = a+(b-a)*Math.exp(-(x-c)*(x-c)/(2*d*d))", "y = a*(1-Math.exp(-b*x))+c", "y = c*Math.pow((x-a)/(d-x),1/b)", "y = a*Math.exp(b*x)", "y = a*Math.pow(x,b)", "y = a+x*(b+x*(c+x*(d+x*(e+x*f))))", "y = a+x*(b+x*(c+x*(d+x*(e+x*(f+x*g)))))", "y = a+x*(b+x*(c+x*(d+x*(e+x*(f+x*(g+x*h))))))", "y = a+x*(b+x*(c+x*(d+x*(e+x*(f+x*(g+x*(h+x*i)))))))", "y = a*Math.exp(-(x-b)*(x-b)/(2*c*c))", "y = a*(1-Math.exp(-b*x))", "y = a*Math.pow(1-Math.exp(-b*x),c)", "y = a+b*Math.erf((x-c)/d)"};
    public static final int IterFactor = 500;
    private static final int CUSTOM = 100;
    private static final int GAUSSIAN_INTERNAL = 101;
    private static final int RODBARD_INTERNAL = 102;
    private int fitType = -1;
    private double[] xData;
    private double[] yData;
    private double[] weights;
    private double[] xDataSave;
    private double[] yDataSave;
    private int numPoints;
    private double ySign = 0.0;
    private double sumY = Double.NaN;
    private double sumY2 = Double.NaN;
    private double sumWeights = Double.NaN;
    private int numParams;
    private double[] initialParams;
    private double[] initialParamVariations;
    private double[] minimizerInitialParams;
    private double[] minimizerInitialParamVariations;
    private double maxRelError = 1.0E-10;
    private long time;
    private int customParamCount;
    private String customFormula;
    private UserFunction userFunction;
    private Interpreter macro;
    private int macroStartProgramCounter;
    private int numRegressionParams;
    private int offsetParam = -1;
    private int factorParam = -1;
    private boolean hasSlopeParam;
    private double[] finalParams;
    private boolean linearRegressionUsed;
    private boolean restrictPower;
    private Minimizer minimizer = new Minimizer();
    private int minimizerStatus = 1;
    private String errorString;
    private static String[] sortedFitList;
    private static Hashtable<String, Integer> namesTable;

    public CurveFitter(double[] xData, double[] yData) {
        int cleanPoints = 0;
        for (int jj = 0; jj < xData.length; ++jj) {
            if (Double.isNaN(xData[jj] + yData[jj])) continue;
            ++cleanPoints;
        }
        if (cleanPoints == xData.length) {
            this.xData = xData;
            this.yData = yData;
        } else {
            double[] cleanX = new double[cleanPoints];
            double[] cleanY = new double[cleanPoints];
            int ptr = 0;
            for (int jj = 0; jj < xData.length; ++jj) {
                if (Double.isNaN(xData[jj] + yData[jj])) continue;
                cleanX[ptr] = xData[jj];
                cleanY[ptr] = yData[jj];
                ++ptr;
            }
            this.xData = cleanX;
            this.yData = cleanY;
        }
        this.numPoints = this.xData.length;
    }

    public void doFit(int fitType) {
        this.doFit(fitType, false);
    }

    public void doFit(int fitType, boolean showSettings) {
        if ((fitType < 0 || fitType >= fitList.length) && fitType != 100) {
            throw new IllegalArgumentException("Invalid fit type");
        }
        if (fitType == 100 && this.macro == null && this.userFunction == null) {
            throw new IllegalArgumentException("No custom formula!");
        }
        this.fitType = fitType;
        if (this.isModifiedFitType(fitType) && !this.prepareModifiedFitType(fitType)) {
            return;
        }
        this.numParams = this.getNumParams();
        if (fitType != 100) {
            this.getOffsetAndFactorParams();
        }
        this.calculateSumYandY2();
        long startTime = System.currentTimeMillis();
        if (this.fitType == 0) {
            this.finalParams = new double[]{0.0, 0.0, 0.0};
            this.doRegression(this.finalParams);
            this.linearRegressionUsed = true;
        } else {
            this.minimizer.setFunction(this, this.numParams - this.numRegressionParams);
            this.minimizer.setExtraArrayElements(this.numRegressionParams);
            if (this.macro != null) {
                this.minimizer.setMaximumThreads(1);
            }
            if (!this.makeInitialParamsAndVariations(fitType)) {
                return;
            }
            if (showSettings) {
                this.settingsDialog();
            }
            if (this.numRegressionParams > 0) {
                this.modifyInitialParamsAndVariations();
            } else {
                this.minimizerInitialParams = this.initialParams;
                this.minimizerInitialParamVariations = this.initialParamVariations;
            }
            startTime = System.currentTimeMillis();
            double maxAbsError = Math.min(1.0E-6, this.maxRelError) * Math.sqrt(this.sumY2);
            this.minimizer.setMaxError(this.maxRelError, maxAbsError);
            this.minimizerStatus = this.minimizer.minimize(this.minimizerInitialParams, this.minimizerInitialParamVariations);
            this.finalParams = this.minimizer.getParams();
            if (this.numRegressionParams > 0) {
                this.minimizerParamsToFullParams(this.finalParams, false);
            }
        }
        if (this.isModifiedFitType(fitType)) {
            this.postProcessModifiedFitType(fitType);
        }
        if (fitType == 24 && this.finalParams[3] < 0.0) {
            this.finalParams[1] = -this.finalParams[1];
            this.finalParams[3] = -this.finalParams[3];
        }
        switch (fitType) {
            case 12: {
                this.finalParams[3] = Math.abs(this.finalParams[3]);
                break;
            }
            case 21: {
                this.finalParams[2] = Math.abs(this.finalParams[2]);
            }
        }
        this.time = System.currentTimeMillis() - startTime;
    }

    public int doCustomFit(String equation, double[] initialParams, boolean showSettings) {
        block4: {
            this.customFormula = null;
            this.customParamCount = CurveFitter.getNumParams(equation);
            if (this.customParamCount == 0) {
                return 0;
            }
            this.customFormula = equation;
            String code = "var x, a, b, c, d, e, f;\nfunction dummy() {}\n" + equation + ";\n";
            this.macroStartProgramCounter = 21;
            this.macro = new Interpreter();
            try {
                this.macro.run(code, null);
            }
            catch (Exception e) {
                if ("Macro canceled".equals(e.getMessage())) break block4;
                IJ.handleException(e);
            }
        }
        if (this.macro.wasError()) {
            return 0;
        }
        this.initialParams = initialParams;
        this.doFit(100, showSettings);
        return this.customParamCount;
    }

    public void doCustomFit(UserFunction userFunction, int numParams, String formula, double[] initialParams, double[] initialParamVariations, boolean showSettings) {
        this.userFunction = userFunction;
        this.customParamCount = numParams;
        this.initialParams = initialParams;
        this.initialParamVariations = initialParamVariations;
        this.customFormula = formula == null ? "(defined in plugin)" : formula;
        this.doFit(100, showSettings);
    }

    public void setInitialParameters(double[] initialParams) {
        this.initialParams = initialParams;
    }

    public void setWeights(double[] weights) {
        this.weights = weights;
    }

    public Minimizer getMinimizer() {
        return this.minimizer;
    }

    public void setOffsetMultiplySlopeParams(int offsetParam, int multiplyParam, int slopeParam) {
        if (multiplyParam >= 0 && slopeParam >= 0) {
            throw new IllegalArgumentException("CurveFitter: only one of multiplyParam and slopeParam may be given (i.e., >=0)");
        }
        this.offsetParam = offsetParam;
        this.hasSlopeParam = slopeParam >= 0;
        this.factorParam = this.hasSlopeParam ? slopeParam : multiplyParam;
        this.numRegressionParams = 0;
        if (this.factorParam >= 0 && this.factorParam == offsetParam) {
            throw new IllegalArgumentException("CurveFitter: offsetParam and slopeParam/factorParam must be different");
        }
        if (offsetParam >= 0) {
            ++this.numRegressionParams;
        }
        if (this.factorParam >= 0) {
            ++this.numRegressionParams;
        }
    }

    public int getNumParams() {
        if (this.fitType == 100) {
            return this.customParamCount;
        }
        return CurveFitter.getNumParams(this.fitType);
    }

    public static int getNumParams(int fitType) {
        switch (fitType) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 17: {
                return 6;
            }
            case 18: {
                return 7;
            }
            case 19: {
                return 8;
            }
            case 20: {
                return 9;
            }
            case 4: 
            case 15: {
                return 2;
            }
            case 5: 
            case 16: {
                return 2;
            }
            case 22: {
                return 2;
            }
            case 6: {
                return 2;
            }
            case 9: {
                return 3;
            }
            case 21: {
                return 3;
            }
            case 13: {
                return 3;
            }
            case 23: {
                return 3;
            }
            case 11: {
                return 3;
            }
            case 7: 
            case 10: 
            case 14: 
            case 102: {
                return 4;
            }
            case 8: {
                return 4;
            }
            case 12: 
            case 101: {
                return 4;
            }
            case 24: {
                return 4;
            }
        }
        return 0;
    }

    public static int getNumParams(String customFormula) {
        Program pgm = new Tokenizer().tokenize(customFormula);
        if (!pgm.hasWord("y") || !pgm.hasWord("x")) {
            return 0;
        }
        String[] params = new String[]{"a", "b", "c", "d", "e", "f"};
        int customParamCount = 0;
        for (int i = 0; i < params.length; ++i) {
            if (!pgm.hasWord(params[i])) continue;
            ++customParamCount;
        }
        return customParamCount;
    }

    public final double f(double x) {
        if (this.finalParams == null) {
            this.finalParams = this.minimizer.getParams();
        }
        return this.f(this.finalParams, x);
    }

    public final double f(double[] p, double x) {
        if (this.fitType != 100) {
            return CurveFitter.f(this.fitType, p, x);
        }
        if (this.macro == null) {
            return this.userFunction.userFunction(p, x);
        }
        this.macro.setVariable("x", x);
        this.macro.setVariable("a", p[0]);
        if (this.customParamCount > 1) {
            this.macro.setVariable("b", p[1]);
        }
        if (this.customParamCount > 2) {
            this.macro.setVariable("c", p[2]);
        }
        if (this.customParamCount > 3) {
            this.macro.setVariable("d", p[3]);
        }
        if (this.customParamCount > 4) {
            this.macro.setVariable("e", p[4]);
        }
        if (this.customParamCount > 5) {
            this.macro.setVariable("f", p[5]);
        }
        this.macro.run(this.macroStartProgramCounter);
        return this.macro.getVariable("y");
    }

    public static double f(int fitType, double[] p, double x) {
        switch (fitType) {
            case 0: {
                return p[0] + x * p[1];
            }
            case 1: {
                return p[0] + x * (p[1] + x * p[2]);
            }
            case 2: {
                return p[0] + x * (p[1] + x * (p[2] + x * p[3]));
            }
            case 3: {
                return p[0] + x * (p[1] + x * (p[2] + x * (p[3] + x * p[4])));
            }
            case 17: {
                return p[0] + x * (p[1] + x * (p[2] + x * (p[3] + x * (p[4] + x * p[5]))));
            }
            case 18: {
                return p[0] + x * (p[1] + x * (p[2] + x * (p[3] + x * (p[4] + x * (p[5] + x * p[6])))));
            }
            case 19: {
                return p[0] + x * (p[1] + x * (p[2] + x * (p[3] + x * (p[4] + x * (p[5] + x * (p[6] + x * p[7]))))));
            }
            case 20: {
                return p[0] + x * (p[1] + x * (p[2] + x * (p[3] + x * (p[4] + x * (p[5] + x * (p[6] + x * (p[7] + x * p[8])))))));
            }
            case 4: 
            case 15: {
                return p[0] * Math.exp(p[1] * x);
            }
            case 11: {
                return p[0] * Math.exp(-p[1] * x) + p[2];
            }
            case 13: {
                return p[0] * (1.0 - Math.exp(-p[1] * x)) + p[2];
            }
            case 22: {
                return p[0] * (1.0 - Math.exp(-p[1] * x));
            }
            case 23: {
                double value = p[0] * Math.pow(1.0 - Math.exp(-p[1] * x), p[2]);
                return value;
            }
            case 12: {
                return p[0] + (p[1] - p[0]) * Math.exp(-(x - p[2]) * (x - p[2]) / (2.0 * p[3] * p[3]));
            }
            case 101: {
                return p[0] + p[1] * Math.exp(-(x - p[2]) * (x - p[2]) / (2.0 * p[3] * p[3]));
            }
            case 21: {
                return p[0] * Math.exp(-(x - p[1]) * (x - p[1]) / (2.0 * p[2] * p[2]));
            }
            case 5: 
            case 16: {
                return p[0] * Math.pow(x, p[1]);
            }
            case 6: {
                if (x == 0.0) {
                    return -1000.0 * p[0];
                }
                return p[0] * Math.log(p[1] * x);
            }
            case 7: {
                double ex = Math.pow(x / p[2], p[1]);
                return p[3] + (p[0] - p[3]) / (1.0 + ex);
            }
            case 102: {
                double ex = Math.pow(x / p[2], p[1]);
                return p[3] + p[0] / (1.0 + ex);
            }
            case 8: {
                if (p[0] >= x) {
                    return 0.0;
                }
                if (p[1] <= 0.0) {
                    return Double.NaN;
                }
                if (p[2] <= 0.0) {
                    return Double.NaN;
                }
                if (p[3] <= 0.0) {
                    return Double.NaN;
                }
                double pw = Math.pow(x - p[0], p[2]);
                double e = Math.exp(-(x - p[0]) / p[3]);
                return p[1] * pw * e;
            }
            case 9: {
                double tmp = x - p[2];
                if (tmp <= 0.0) {
                    return Double.NaN;
                }
                return p[0] + p[1] * Math.log(tmp);
            }
            case 10: 
            case 14: {
                double y;
                if (p[3] - x < 9.9E-324 || x < p[0]) {
                    y = fitType == 14 ? Double.NaN : 0.0;
                } else {
                    y = (x - p[0]) / (p[3] - x);
                    y = Math.pow(y, 1.0 / p[1]);
                    y *= p[2];
                }
                return y;
            }
            case 24: {
                return p[0] + p[1] * IJMath.erf((x - p[2]) / p[3]);
            }
        }
        return 0.0;
    }

    public double[] getParams() {
        return this.finalParams == null ? this.minimizer.getParams() : this.finalParams;
    }

    public double[] getResiduals() {
        double[] params = this.getParams();
        double[] residuals = new double[this.xData.length];
        for (int i = 0; i < this.xData.length; ++i) {
            residuals[i] = this.yData[i] - this.f(params, this.xData[i]);
        }
        return residuals;
    }

    public double getSumResidualsSqr() {
        return this.getParams()[this.numParams];
    }

    public double getSD() {
        double[] residuals = this.getResiduals();
        int n = residuals.length;
        double sum = 0.0;
        double sum2 = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += residuals[i];
            sum2 += residuals[i] * residuals[i];
        }
        double stdDev = sum2 - sum * sum / (double)n;
        return Math.sqrt(stdDev / ((double)n - 1.0));
    }

    public double getRSquared() {
        if (Double.isNaN(this.sumY)) {
            this.calculateSumYandY2();
        }
        double sumMeanDiffSqr = this.sumY2 - this.sumY * this.sumY / this.sumWeights;
        double rSquared = 0.0;
        if (sumMeanDiffSqr > 0.0) {
            rSquared = 1.0 - this.getSumResidualsSqr() / sumMeanDiffSqr;
        }
        return rSquared;
    }

    public double getFitGoodness() {
        if (Double.isNaN(this.sumY)) {
            this.calculateSumYandY2();
        }
        double sumMeanDiffSqr = this.sumY2 - this.sumY * this.sumY / this.sumWeights;
        double fitGoodness = 0.0;
        int degreesOfFreedom = this.numPoints - this.getNumParams();
        if (sumMeanDiffSqr > 0.0 && degreesOfFreedom > 0) {
            fitGoodness = 1.0 - this.getSumResidualsSqr() / sumMeanDiffSqr * (double)this.numPoints / (double)degreesOfFreedom;
        }
        return fitGoodness;
    }

    public int getStatus() {
        return this.linearRegressionUsed ? 0 : this.minimizerStatus;
    }

    public String getStatusString() {
        return this.errorString != null ? this.errorString : Minimizer.STATUS_STRING[this.getStatus()];
    }

    public String getResultString() {
        String resultS = "\nFormula: " + this.getFormula() + "\nMacro code: " + this.getMacroCode() + "\nStatus: " + this.getStatusString();
        if (this.getStatus() == 1) {
            return resultS;
        }
        if (!this.linearRegressionUsed) {
            resultS = resultS + "\nNumber of completed minimizations: " + this.minimizer.getCompletedMinimizations();
        }
        resultS = resultS + "\nNumber of iterations: " + this.getIterations();
        if (!this.linearRegressionUsed) {
            resultS = resultS + " (max: " + this.minimizer.getMaxIterations() + ")";
        }
        resultS = resultS + "\nTime: " + this.time + " ms" + "\nSum of residuals squared: " + IJ.d2s(this.getSumResidualsSqr(), 5, 9) + "\nStandard deviation: " + IJ.d2s(this.getSD(), 5, 9) + "\nR^2: " + IJ.d2s(this.getRSquared(), 5) + "\nParameters:";
        char pChar = 'a';
        double[] pVal = this.getParams();
        for (int i = 0; i < this.numParams; ++i) {
            resultS = resultS + "\n\t" + pChar + " = " + IJ.d2s(pVal[i], 5, 9);
            pChar = (char)(pChar + '\u0001');
        }
        return resultS;
    }

    public void setRestarts(int maxRestarts) {
        this.minimizer.setMaxRestarts(maxRestarts);
    }

    public void setMaxError(double maxRelError) {
        if (Double.isNaN(maxRelError)) {
            return;
        }
        if (maxRelError > 0.1) {
            maxRelError = 0.1;
        }
        if (maxRelError < 1.0E-16) {
            maxRelError = 1.0E-16;
        }
        this.maxRelError = maxRelError;
    }

    public void setStatusAndEsc(String ijStatusString, boolean checkEscape) {
        this.minimizer.setStatusAndEsc(ijStatusString, checkEscape);
    }

    public int getIterations() {
        return this.linearRegressionUsed ? 1 : this.minimizer.getIterations();
    }

    public int getMaxIterations() {
        return this.minimizer.getMaxIterations();
    }

    public void setMaxIterations(int maxIter) {
        this.minimizer.setMaxIterations(maxIter);
    }

    public int getRestarts() {
        return this.minimizer.getMaxRestarts();
    }

    public double[] getXPoints() {
        return this.xData;
    }

    public double[] getYPoints() {
        return this.yData;
    }

    public int getFit() {
        return this.fitType;
    }

    public String getName() {
        if (this.fitType == 100) {
            return "User-defined";
        }
        if (this.fitType == 101) {
            this.fitType = 12;
        } else if (this.fitType == 102) {
            this.fitType = 7;
        }
        return fitList[this.fitType];
    }

    public String getFormula() {
        if (this.fitType == 100) {
            return this.customFormula;
        }
        if (this.fitType == 101) {
            this.fitType = 12;
        } else if (this.fitType == 102) {
            this.fitType = 7;
        }
        return fList[this.fitType];
    }

    public String getMacroCode() {
        if (this.fitType == 100) {
            return this.customFormula;
        }
        if (this.fitType == 101) {
            this.fitType = 12;
        } else if (this.fitType == 102) {
            this.fitType = 7;
        }
        return fMacro[this.fitType];
    }

    public static String[] getSortedFitList() {
        if (sortedFitList == null) {
            String[] tmpList = new String[fitList.length];
            for (int i = 0; i < fitList.length; ++i) {
                tmpList[i] = fitList[sortedTypes[i]];
            }
            sortedFitList = tmpList;
        }
        return sortedFitList;
    }

    public static int getFitCode(String fitName) {
        Integer i;
        if (namesTable == null) {
            Hashtable<String, Integer> h = new Hashtable<String, Integer>();
            for (int i2 = 0; i2 < fitList.length; ++i2) {
                h.put(fitList[i2], new Integer(i2));
            }
            namesTable = h;
        }
        return (i = namesTable.get(fitName)) != null ? i : -1;
    }

    @Override
    public final double userFunction(double[] params, double dummy) {
        double sumResidualsSqr = 0.0;
        if (this.numRegressionParams == 0) {
            for (int i = 0; i < this.numPoints; ++i) {
                double fValue = this.f(params, this.xData[i]);
                double resSqr = this.sqr(fValue - this.yData[i]);
                if (this.weights != null) {
                    resSqr *= this.weights[i];
                }
                sumResidualsSqr += resSqr;
            }
        } else {
            this.minimizerParamsToFullParams(params, true);
            this.doRegression(params);
            sumResidualsSqr = this.fullParamsToMinimizerParams(params);
        }
        return sumResidualsSqr;
    }

    private void minimizerParamsToFullParams(double[] params, boolean forRegression) {
        int i;
        boolean shouldTransformToSmallerParams = false;
        double offset = 0.0;
        double factor = this.hasSlopeParam ? 0.0 : 1.0;
        double sumResidualsSqr = 0.0;
        if (!forRegression) {
            i = params.length - 1;
            if (this.factorParam >= 0) {
                factor = params[i--];
            }
            if (this.offsetParam >= 0) {
                offset = params[i];
            }
            params[this.numParams] = sumResidualsSqr = params[this.numParams - this.numRegressionParams];
        }
        int iM = this.numParams - this.numRegressionParams - 1;
        for (i = this.numParams - 1; i >= 0; --i) {
            params[i] = i == this.offsetParam ? offset : (i == this.factorParam ? factor : (iM >= 0 ? params[iM--] : Double.NaN));
        }
        params[this.numParams] = sumResidualsSqr;
    }

    private void doRegression(double[] params) {
        double sumX = 0.0;
        double sumX2 = 0.0;
        double sumXY = 0.0;
        double sumY = 0.0;
        double sumY2 = 0.0;
        double sumWeights = 0.0;
        for (int i = 0; i < this.numPoints; ++i) {
            double y;
            double x;
            double fValue;
            double d = fValue = this.fitType == 0 ? 0.0 : this.f(params, this.xData[i]);
            if (Double.isNaN(fValue)) {
                params[this.numParams] = Double.NaN;
                return;
            }
            double w = this.weights == null ? 1.0 : this.weights[i];
            sumWeights += w;
            if (this.hasSlopeParam) {
                x = this.xData[i];
                y = this.yData[i] - fValue;
                sumX += x * w;
                sumX2 += x * x * w;
                sumXY += x * y * w;
                sumY2 += y * y * w;
                sumY += y * w;
                continue;
            }
            x = fValue;
            y = this.yData[i];
            sumX += fValue * w;
            sumX2 += fValue * fValue * w;
            sumXY += fValue * this.yData[i] * w;
        }
        if (!this.hasSlopeParam) {
            sumY = this.sumY;
            sumY2 = this.sumY2;
        }
        double factor = 0.0;
        double sumResidualsSqr = 0.0;
        if (this.offsetParam < 0) {
            factor = sumXY / sumX2;
            if (Double.isNaN(factor) || Double.isInfinite(factor)) {
                factor = 0.0;
            }
            if ((sumResidualsSqr = sumY2 + factor * (factor * sumX2 - 2.0 * sumXY)) < 2.0E-15 * sumY2) {
                sumResidualsSqr = 2.0E-15 * sumY2;
            }
        } else {
            double offset;
            if (this.factorParam >= 0) {
                factor = (sumXY - sumX * sumY / sumWeights) / (sumX2 - sumX * sumX / sumWeights);
                if (this.restrictPower & factor <= 0.0) {
                    factor = 1.0E-100;
                } else if (Double.isNaN(factor) || Double.isInfinite(factor)) {
                    factor = 0.0;
                }
            }
            params[this.offsetParam] = offset = (sumY - factor * sumX) / sumWeights;
            sumResidualsSqr = this.sqr(factor) * sumX2 + sumWeights * this.sqr(offset) + sumY2 + 2.0 * factor * offset * sumX - 2.0 * factor * sumXY - 2.0 * offset * sumY;
            if (sumResidualsSqr < 2.0E-15 * (this.sqr(factor) * sumX2 + sumWeights * this.sqr(offset) + sumY2)) {
                sumResidualsSqr = 2.0E-15 * (this.sqr(factor) * sumX2 + sumWeights * this.sqr(offset) + sumY2);
            }
        }
        params[this.numParams] = sumResidualsSqr;
        if (this.factorParam >= 0) {
            params[this.factorParam] = factor;
        }
    }

    private double fullParamsToMinimizerParams(double[] params) {
        int i;
        double offset = this.offsetParam >= 0 ? params[this.offsetParam] : 0.0;
        double factor = this.factorParam >= 0 ? params[this.factorParam] : 0.0;
        double sumResidualsSqr = params[this.numParams];
        int iNew = 0;
        for (i = 0; i < this.numParams; ++i) {
            if (i == this.factorParam || i == this.offsetParam) continue;
            params[iNew++] = params[i];
        }
        i = params.length - 1;
        if (this.factorParam >= 0) {
            params[i--] = factor;
        }
        if (this.offsetParam >= 0) {
            params[i--] = offset;
        }
        params[i--] = sumResidualsSqr;
        return sumResidualsSqr;
    }

    private void modifyInitialParamsAndVariations() {
        this.minimizerInitialParams = (double[])this.initialParams.clone();
        this.minimizerInitialParamVariations = (double[])this.initialParamVariations.clone();
        if (this.numRegressionParams > 0) {
            int iNew = 0;
            for (int i = 0; i < this.numParams; ++i) {
                if (i == this.factorParam || i == this.offsetParam) continue;
                this.minimizerInitialParams[iNew] = this.minimizerInitialParams[i];
                this.minimizerInitialParamVariations[iNew] = this.minimizerInitialParamVariations[i];
                ++iNew;
            }
        }
    }

    private boolean makeInitialParamsAndVariations(int fitType) {
        int i;
        int i2;
        boolean hasInitialParamVariations;
        if (this.numPoints == 0) {
            this.errorString = "No data to fit";
            return false;
        }
        boolean hasInitialParams = this.initialParams != null;
        boolean bl = hasInitialParamVariations = this.initialParamVariations != null;
        if (!hasInitialParams) {
            this.initialParams = new double[this.numParams];
            if (fitType == 100) {
                for (i2 = 0; i2 < this.numParams; ++i2) {
                    this.initialParams[i2] = 1.0;
                }
            }
        }
        if (!hasInitialParamVariations) {
            this.initialParamVariations = new double[this.numParams];
        }
        if (fitType == 100) {
            for (i2 = 0; i2 < this.numParams; ++i2) {
                this.initialParamVariations[i2] = 0.1 * this.initialParams[i2];
                if (this.initialParamVariations[i2] != 0.0) continue;
                this.initialParamVariations[i2] = 0.01;
            }
            return true;
        }
        double firstx = this.xData[0];
        double firsty = this.yData[0];
        double lastx = this.xData[this.numPoints - 1];
        double lasty = this.yData[this.numPoints - 1];
        double xMin = firstx;
        double xMax = firstx;
        double yMin = firsty;
        double yMax = firsty;
        double xMean = firstx;
        double yMean = firsty;
        double xOfMax = firstx;
        for (int i3 = 1; i3 < this.numPoints; ++i3) {
            xMean += this.xData[i3];
            yMean += this.yData[i3];
            if (this.xData[i3] > xMax) {
                xMax = this.xData[i3];
            }
            if (this.xData[i3] < xMin) {
                xMin = this.xData[i3];
            }
            if (this.yData[i3] > yMax) {
                yMax = this.yData[i3];
                xOfMax = this.xData[i3];
            }
            if (!(this.yData[i3] < yMin)) continue;
            yMin = this.yData[i3];
        }
        xMean /= (double)this.numPoints;
        yMean /= (double)this.numPoints;
        double slope = (lasty - firsty) / (lastx - firstx);
        if (Double.isNaN(slope) || Double.isInfinite(slope)) {
            slope = 0.0;
        }
        double yIntercept = yMean - slope * xMean;
        if (xMin < 0.0 && (fitType == 5 || fitType == 23)) {
            this.errorString = "Cannot fit " + fitList[fitType] + " when x<0";
            return false;
        }
        if (xMin < 0.0 && xMax > 0.0 && fitType == 7) {
            this.errorString = "Cannot fit " + fitList[fitType] + " to mixture of x<0 and x>0";
            return false;
        }
        if (xMin <= 0.0 && fitType == 6) {
            this.errorString = "Cannot fit " + fitList[fitType] + " when x<=0";
            return false;
        }
        if (!hasInitialParams) {
            switch (fitType) {
                case 4: {
                    this.initialParams[1] = 1.0 / (xMax - xMin + 1.0E-100) * Math.signum(yMean) * Math.signum(slope);
                    this.initialParams[0] = yMean / Math.exp(this.initialParams[1] * xMean);
                    break;
                }
                case 11: 
                case 13: {
                    this.initialParams[1] = 1.0 / (xMax - xMin + 1.0E-100);
                    this.initialParams[0] = (yMax - yMin + 1.0E-100) / Math.exp(this.initialParams[1] * xMean) * Math.signum(slope) * (double)fitType == 13.0 ? 1.0 : -1.0;
                    this.initialParams[2] = 0.5 * yMean;
                    break;
                }
                case 22: {
                    this.initialParams[1] = 1.0 / (xMax - xMin + 1.0E-100) * Math.signum(yMean) * Math.signum(slope);
                    this.initialParams[0] = yMean / Math.exp(this.initialParams[1] * xMean);
                    break;
                }
                case 5: {
                    this.initialParams[0] = yMean / Math.abs(xMean + 1.0E-100);
                    this.initialParams[1] = 1.0;
                    break;
                }
                case 6: {
                    this.initialParams[0] = yMean;
                    this.initialParams[1] = Math.E / (xMax + 1.0E-100);
                    break;
                }
                case 9: {
                    this.initialParams[0] = yMean;
                    this.initialParams[1] = (yMax - yMin + 1.0E-100) / (xMax - xMin + 1.0E-100);
                    this.initialParams[2] = Math.min(0.0, -xMin - 0.1 * (xMax - xMin) - 1.0E-100);
                    break;
                }
                case 7: {
                    this.initialParams[0] = firsty;
                    this.initialParams[1] = 1.0;
                    this.initialParams[2] = xMin < 0.0 ? xMin : xMax;
                    this.initialParams[3] = lasty;
                    break;
                }
                case 10: 
                case 14: {
                    this.initialParams[0] = xMin - 0.1 * (xMax - xMin);
                    this.initialParams[1] = slope >= 0.0 ? 1.0 : -1.0;
                    this.initialParams[2] = yMax;
                    this.initialParams[3] = xMax + (xMax - xMin);
                    break;
                }
                case 8: {
                    this.initialParams[0] = xMin;
                    double cd = xOfMax - xMin;
                    if (cd < 0.1 * (xMax - xMin)) {
                        cd = 0.1 * (xMax - xMin);
                    }
                    this.initialParams[2] = Math.sqrt(cd);
                    this.initialParams[3] = Math.sqrt(cd);
                    this.initialParams[1] = yMax / (Math.pow(cd, this.initialParams[2]) * Math.exp(-cd / this.initialParams[3]));
                    break;
                }
                case 12: {
                    this.initialParams[0] = yMin;
                    this.initialParams[1] = yMax;
                    this.initialParams[2] = xOfMax;
                    this.initialParams[3] = 0.39894 * (xMax - xMin) * (yMean - yMin) / (yMax - yMin + 1.0E-100);
                    break;
                }
                case 21: {
                    this.initialParams[0] = yMax;
                    this.initialParams[1] = xOfMax;
                    this.initialParams[2] = 0.39894 * (xMax - xMin) * yMean / (yMax + 1.0E-100);
                    break;
                }
                case 23: {
                    this.initialParams[0] = yMax;
                    this.initialParams[2] = 1.5;
                    for (i = 1; i < this.numPoints; ++i) {
                        if (!(this.yData[i] > 0.5 * yMax)) continue;
                        this.initialParams[1] = 1.0 / this.xData[i];
                        break;
                    }
                    if (!Double.isNaN(this.initialParams[1]) && !(this.initialParams[1] > 1000.0 / xMax)) break;
                    this.initialParams[1] = 10.0 / xMax;
                    break;
                }
                case 24: {
                    this.initialParams[0] = 0.5 * (yMax + yMin);
                    this.initialParams[1] = 0.5 * (yMax - yMin + 1.0E-100) * (double)(lasty > firsty ? 1 : -1);
                    this.initialParams[2] = xMin + (xMax - xMin) * (lasty > firsty ? yMax - yMean : yMean - yMin) / (yMax - yMin + 1.0E-100);
                    this.initialParams[3] = 0.1 * (xMax - xMin + 1.0E-100);
                }
            }
        }
        if (!hasInitialParamVariations) {
            for (int i4 = 0; i4 < this.numParams; ++i4) {
                this.initialParamVariations[i4] = 0.1 * this.initialParams[i4];
            }
            switch (fitType) {
                case 1: 
                case 2: 
                case 3: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    double xFactor = 0.5 * Math.max(Math.abs(xMax + xMin), xMax - xMin);
                    this.initialParamVariations[this.numParams - 1] = (yMax - yMin) / (Math.pow(0.5 * (xMax - xMin), this.numParams - 1) + 1.0E-100);
                    for (i = this.numParams - 2; i >= 0; --i) {
                        this.initialParamVariations[i] = this.initialParamVariations[i + 1] * xFactor;
                    }
                    break;
                }
                case 4: 
                case 11: 
                case 13: {
                    this.initialParamVariations[1] = 0.1 / (xMax - xMin + 1.0E-100);
                    break;
                }
                case 7: {
                    this.initialParamVariations[2] = 0.5 * Math.max(xMax - xMin, Math.abs(xMean));
                    this.initialParamVariations[3] = 0.5 * Math.max(yMax - yMin, Math.abs(yMax));
                    break;
                }
                case 14: {
                    this.initialParamVariations[0] = 0.01 * Math.max(xMax - xMin, Math.abs(xMax));
                    this.initialParamVariations[2] = 0.1 * Math.max(yMax - yMin, Math.abs(yMax));
                    this.initialParamVariations[3] = 0.1 * Math.max(xMax - xMin, Math.abs(xMean));
                    break;
                }
                case 8: {
                    this.initialParamVariations[0] = 0.1 * Math.max(yMax - yMin, Math.abs(yMax));
                    double ab = xOfMax - firstx + 0.1 * (xMax - xMin + 1.0E-100);
                    this.initialParamVariations[2] = 0.1 * Math.sqrt(ab);
                    this.initialParamVariations[3] = 0.1 * Math.sqrt(ab);
                    break;
                }
                case 12: {
                    this.initialParamVariations[2] = 0.2 * this.initialParams[3];
                    break;
                }
                case 21: {
                    this.initialParamVariations[1] = 0.2 * this.initialParams[2];
                    break;
                }
                case 24: {
                    this.initialParamVariations[2] = 0.1 * (xMax - xMin + 1.0E-100);
                    this.initialParamVariations[3] = 0.5 * this.initialParams[3];
                }
            }
        }
        return true;
    }

    private void getOffsetAndFactorParams() {
        this.offsetParam = -1;
        this.factorParam = -1;
        this.hasSlopeParam = false;
        switch (this.fitType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                this.offsetParam = 0;
                this.factorParam = 1;
                this.hasSlopeParam = true;
                break;
            }
            case 4: {
                this.factorParam = 0;
                break;
            }
            case 11: 
            case 13: {
                this.offsetParam = 2;
                this.factorParam = 0;
                break;
            }
            case 22: {
                this.factorParam = 0;
                break;
            }
            case 23: {
                this.factorParam = 0;
                break;
            }
            case 5: {
                this.factorParam = 0;
                break;
            }
            case 6: {
                this.factorParam = 0;
                break;
            }
            case 9: {
                this.offsetParam = 0;
                this.factorParam = 1;
                break;
            }
            case 102: {
                this.offsetParam = 3;
                this.factorParam = 0;
                break;
            }
            case 14: {
                this.factorParam = 2;
                break;
            }
            case 8: {
                this.factorParam = 1;
                break;
            }
            case 101: {
                this.offsetParam = 0;
                this.factorParam = 1;
                break;
            }
            case 21: {
                this.factorParam = 0;
                break;
            }
            case 24: {
                this.offsetParam = 0;
                this.factorParam = 1;
            }
        }
        this.numRegressionParams = 0;
        if (this.offsetParam >= 0) {
            ++this.numRegressionParams;
        }
        if (this.factorParam >= 0) {
            ++this.numRegressionParams;
        }
    }

    private void calculateSumYandY2() {
        this.sumY = 0.0;
        this.sumY2 = 0.0;
        this.sumWeights = 0.0;
        double w = 1.0;
        for (int i = 0; i < this.numPoints; ++i) {
            double y = this.yData[i];
            if (this.weights != null) {
                w = this.weights[i];
            }
            this.sumY += y * w;
            this.sumY2 += y * y * w;
            this.sumWeights += w;
        }
    }

    private boolean isModifiedFitType(int fitType) {
        return fitType == 16 || fitType == 15 || fitType == 7 || fitType == 10 || fitType == 12;
    }

    private boolean prepareModifiedFitType(int fitType) {
        if (fitType == 12) {
            this.fitType = 101;
            return true;
        }
        if (fitType == 7) {
            this.fitType = 102;
            return true;
        }
        if (fitType == 16 || fitType == 15) {
            if (fitType == 16) {
                this.xDataSave = this.xData;
                this.xData = new double[this.numPoints];
            }
            this.yDataSave = this.yData;
            this.yData = new double[this.numPoints];
            this.ySign = 0.0;
            this.numPoints = 0;
            for (int i = 0; i < this.xData.length; ++i) {
                double y = this.yDataSave[i];
                if (fitType == 16) {
                    double x = this.xDataSave[i];
                    if (x == 0.0 && y == 0.0) {
                        this.restrictPower = true;
                        continue;
                    }
                    if (x <= 0.0) {
                        this.errorString = "Cannot fit x<=0";
                        return false;
                    }
                    this.xData[this.numPoints] = Math.log(x);
                }
                if (this.ySign == 0.0) {
                    this.ySign = Math.signum(y);
                }
                if (y * this.ySign <= 0.0) {
                    this.errorString = "Cannot fit y=0 or mixture of y>0, y<0";
                    return false;
                }
                this.yData[this.numPoints] = Math.log(y * this.ySign);
                ++this.numPoints;
            }
            this.fitType = 0;
        } else if (fitType == 10) {
            this.xDataSave = this.xData;
            this.yDataSave = this.yData;
            this.xData = this.yDataSave;
            this.yData = this.xDataSave;
            this.fitType = 102;
        }
        return true;
    }

    private void postProcessModifiedFitType(int fitType) {
        if (fitType == 16 || fitType == 15) {
            this.finalParams[0] = this.ySign * Math.exp(this.finalParams[0]);
        }
        if (fitType == 12) {
            this.finalParams[1] = this.finalParams[1] + this.finalParams[0];
        } else if (fitType == 7 || fitType == 10) {
            this.finalParams[0] = this.finalParams[0] + this.finalParams[3];
        }
        if (this.xDataSave != null) {
            this.xData = this.xDataSave;
            this.numPoints = this.xData.length;
        }
        if (this.yDataSave != null) {
            this.yData = this.yDataSave;
        }
        this.fitType = fitType;
    }

    private final double sqr(double d) {
        return d * d;
    }

    private void settingsDialog() {
        int i;
        if (this.initialParamVariations == null) {
            this.initialParamVariations = new double[this.numParams];
        }
        GenericDialog gd = new GenericDialog("Simplex Fitting Options");
        gd.addMessage("Function name: " + this.getName() + "\n" + "Formula: " + this.getFormula());
        int pChar = 97;
        for (i = 0; i < this.numParams; ++i) {
            gd.addNumericField("Initial_" + (char)(pChar + i) + ":", this.initialParams[i], 2);
        }
        gd.addNumericField("Maximum iterations:", this.minimizer.getMaxIterations(), 0);
        gd.addNumericField("Number of restarts:", this.minimizer.getMaxRestarts(), 0);
        gd.addNumericField("Error tolerance [1*10^(-x)]:", -(Math.log(this.maxRelError) / Math.log(10.0)), 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        for (i = 0; i < this.numParams; ++i) {
            double p = gd.getNextNumber();
            if (Double.isNaN(p)) continue;
            this.initialParams[i] = p;
            this.initialParamVariations[i] = Math.max(0.01 * p, 0.001 * this.initialParamVariations[i]);
        }
        double n = gd.getNextNumber();
        if (n > 0.0) {
            this.minimizer.setMaxIterations((int)n);
        }
        if ((n = gd.getNextNumber()) >= 0.0) {
            this.minimizer.setMaxRestarts((int)n);
        }
        n = gd.getNextNumber();
        this.setMaxError(Math.pow(10.0, -n));
    }

    public static int getMax(double[] array) {
        double max = array[0];
        int index = 0;
        for (int i = 1; i < array.length; ++i) {
            if (!(max < array[i])) continue;
            max = array[i];
            index = i;
        }
        return index;
    }

    public Plot getPlot() {
        return this.getPlot(100);
    }

    public Plot getPlot(int points) {
        int PLOT_WIDTH = 600;
        int PLOT_HEIGHT = 350;
        double[] x = this.getXPoints();
        double[] y = this.getYPoints();
        if (this.getStatus() == 1) {
            Plot plot = new Plot(this.getFormula(), "X", "Y");
            plot.setColor(Color.RED, Color.RED);
            plot.addPoints(x, y, 0);
            plot.setColor(Color.BLUE);
            plot.setFrameSize(PLOT_WIDTH, PLOT_HEIGHT);
            plot.addLabel(0.02, 0.1, this.getName());
            plot.addLabel(0.02, 0.2, this.getStatusString());
            return plot;
        }
        int npoints = points;
        if (npoints < x.length) {
            npoints = x.length;
        }
        if (npoints > 1000) {
            npoints = 1000;
        }
        double[] a = Tools.getMinMax(x);
        double xmin = a[0];
        double xmax = a[1];
        if (points == 256) {
            npoints = points;
            xmin = 0.0;
            xmax = 255.0;
        }
        a = Tools.getMinMax(y);
        double ymin = a[0];
        double ymax = a[1];
        float[] px = new float[npoints];
        float[] py = new float[npoints];
        double inc = (xmax - xmin) / (double)(npoints - 1);
        double tmp = xmin;
        for (int i = 0; i < npoints; ++i) {
            px[i] = (float)tmp;
            tmp += inc;
        }
        double[] params = this.getParams();
        for (int i = 0; i < npoints; ++i) {
            py[i] = (float)this.f(params, px[i]);
        }
        a = Tools.getMinMax(py);
        double dataRange = ymax - ymin;
        ymin = Math.max(ymin - dataRange, Math.min(ymin, a[0]));
        ymax = Math.min(ymax + dataRange, Math.max(ymax, a[1]));
        Plot plot = new Plot(this.getFormula(), "X", "Y", px, py);
        plot.setLabel(0, "fit");
        plot.setLimits(xmin, xmax, ymin, ymax);
        plot.setFrameSize(PLOT_WIDTH, PLOT_HEIGHT);
        plot.setColor(Color.RED, Color.RED);
        plot.addPoints(x, y, 0);
        plot.setLabel(1, "data");
        plot.setColor(Color.BLUE);
        StringBuilder legend = new StringBuilder(100);
        legend.append(this.getName());
        legend.append('\n');
        legend.append(this.getFormula());
        legend.append('\n');
        double[] p = this.getParams();
        int n = this.getNumParams();
        char pChar = 'a';
        for (int i = 0; i < n; ++i) {
            legend.append(pChar + " = " + IJ.d2s(p[i], 5, 9) + '\n');
            pChar = (char)(pChar + '\u0001');
        }
        legend.append("R^2 = " + IJ.d2s(this.getRSquared(), 4));
        legend.append('\n');
        plot.addLabel(0.02, 0.1, legend.toString());
        plot.setColor(Color.BLUE);
        return plot;
    }
}

