/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.macro.Interpreter;
import ij.plugin.Colors;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import ij.util.Java2;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class TextRoi
extends Roi {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    static final int MAX_LINES = 50;
    private static final String line1 = "Enter text, then press";
    private static final String line2 = "ctrl+b to add to overlay";
    private static final String line3 = "or ctrl+d to draw.";
    private static final String line1a = "Enter text...";
    private String[] theText = new String[50];
    private static String name = "SansSerif";
    private static int style = 0;
    private static int size = 18;
    private Font font;
    private static boolean antialiasedText = true;
    private static int globalJustification = 0;
    private static Color defaultFillColor;
    private int justification = 0;
    private double previousMag;
    private boolean firstChar = true;
    private boolean firstMouseUp = true;
    private double angle;
    private static double defaultAngle;
    private static boolean firstTime;
    private Roi previousRoi;
    private Graphics fontGraphics;
    private static Font defaultFont;

    public TextRoi(int x, int y, String text) {
        this(x, y, text, defaultFont);
    }

    public TextRoi(String text, double x, double y, Font font) {
        super(x, y, 1.0, 1.0);
        this.init(text, font);
        if (font != null) {
            Graphics g = this.getFontGraphics(font);
            FontMetrics metrics = g.getFontMetrics(font);
            Rectangle2D.Double fbounds = this.getFloatBounds();
            fbounds.y -= (double)metrics.getAscent();
            this.setBounds(fbounds);
        }
    }

    public TextRoi(double x, double y, String text) {
        super(x, y, 1.0, 1.0);
        this.init(text, null);
    }

    public TextRoi(int x, int y, String text, Font font) {
        super(x, y, 1, 1);
        this.init(text, font);
    }

    public TextRoi(double x, double y, String text, Font font) {
        super(x, y, 1.0, 1.0);
        this.init(text, font);
    }

    public TextRoi(double x, double y, double width, double height, String text, Font font) {
        super(x, y, width, height);
        this.init(text, font);
    }

    public static TextRoi create(String text, double x, double y, Font font) {
        return new TextRoi(text, x, y, font);
    }

    public static TextRoi create(double x, double y, String text, Font font) {
        return new TextRoi(x, y, text, font);
    }

    private void init(String text, Font font) {
        String[] lines = Tools.split(text, "\n");
        int count = Math.min(lines.length, 50);
        for (int i = 0; i < count; ++i) {
            this.theText[i] = lines[i];
        }
        if (font == null) {
            font = defaultFont;
        }
        if (font == null) {
            font = new Font("SansSerif", 0, 14);
        }
        this.font = font;
        this.setAntiAlias(antialiasedText);
        this.firstChar = false;
        if (defaultColor != null) {
            this.setStrokeColor(defaultColor);
        }
        this.updateBounds();
    }

    public TextRoi(int x, int y, String text, Font font, Color color) {
        super(x, y, 1, 1);
        if (font == null) {
            font = new Font(name, style, size);
        }
        this.font = font;
        IJ.error("TextRoi", "API has changed. See updated example at\nhttp://imagej.nih.gov/ij/macros/js/TextOverlay.js");
    }

    public TextRoi(int x, int y, ImagePlus imp) {
        super(x, y, imp);
        ImageCanvas ic = imp.getCanvas();
        double mag = this.getMagnification();
        if (mag > 1.0) {
            mag = 1.0;
        }
        if ((double)size < 12.0 / mag) {
            size = (int)(12.0 / mag);
        }
        if (firstTime) {
            this.theText[0] = line1;
            this.theText[1] = line2;
            this.theText[2] = line3;
            firstTime = false;
        } else {
            this.theText[0] = line1a;
        }
        if (this.previousRoi != null && this.previousRoi instanceof TextRoi) {
            this.firstMouseUp = false;
            this.previousRoi = null;
        }
        this.font = new Font(name, style, size);
        this.justification = globalJustification;
        this.setStrokeColor(Toolbar.getForegroundColor());
        this.setAntiAlias(antialiasedText);
        if (WindowManager.getWindow("Fonts") != null) {
            this.setFillColor(defaultFillColor);
            this.setAngle(defaultAngle);
        }
    }

    public void addChar(char c) {
        int i;
        if (this.imp == null) {
            return;
        }
        if (c < ' ' && c != '\b' && c != '\n') {
            return;
        }
        int cline = 0;
        if (this.firstChar) {
            this.theText[cline] = new String("");
            for (i = 1; i < 50; ++i) {
                this.theText[i] = null;
            }
        } else {
            i = 0;
            while (i < this.theText.length && this.theText[i] != null) {
                cline = i++;
            }
        }
        if (c == '\b') {
            if (this.theText[cline].length() > 0) {
                this.theText[cline] = this.theText[cline].substring(0, this.theText[cline].length() - 1);
            } else if (cline > 0) {
                this.theText[cline] = null;
                --cline;
            }
            if (this.angle != 0.0) {
                this.imp.draw();
            } else {
                this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
            }
            this.firstChar = false;
            return;
        }
        if (c == '\n') {
            if (cline < 49) {
                ++cline;
            }
        } else {
            char[] chr = new char[]{c};
            int n = cline;
            this.theText[n] = this.theText[n] + new String(chr);
            this.updateBounds();
            this.updateText();
            this.firstChar = false;
            return;
        }
        this.theText[cline] = "";
        this.updateBounds();
        this.updateText();
    }

    Font getScaledFont() {
        if (this.font == null) {
            this.font = new Font("SansSerif", 0, 14);
        }
        double mag = this.getMagnification();
        if (this.nonScalable || this.imp == null || mag == 1.0) {
            return this.font;
        }
        return this.font.deriveFont((float)((double)this.font.getSize() * mag));
    }

    @Override
    public void drawPixels(ImageProcessor ip) {
        if (!ip.fillValueSet()) {
            ip.setColor(Toolbar.getForegroundColor());
        }
        ip.setFont(this.font);
        ip.setAntialiasedText(this.getAntiAlias());
        FontMetrics metrics = ip.getFontMetrics();
        int fontHeight = metrics.getHeight();
        int descent = metrics.getDescent();
        int i = 0;
        int yy = 0;
        int xi = (int)Math.round(this.getXBase());
        int yi = (int)Math.round(this.getYBase());
        while (i < 50 && this.theText[i] != null) {
            switch (this.justification) {
                case 0: {
                    ip.drawString(this.theText[i], xi, yi + yy + fontHeight);
                    break;
                }
                case 1: {
                    int tw = metrics.stringWidth(this.theText[i]);
                    ip.drawString(this.theText[i], xi + (this.width - tw) / 2, yi + yy + fontHeight);
                    break;
                }
                case 2: {
                    int tw = metrics.stringWidth(this.theText[i]);
                    ip.drawString(this.theText[i], xi + this.width - tw, yi + yy + fontHeight);
                }
            }
            ++i;
            yy += fontHeight;
        }
    }

    @Override
    public void draw(Graphics g) {
        if (IJ.debugMode) {
            IJ.log("draw: " + this.theText[0] + "  " + this.width + "," + this.height);
        }
        if (Interpreter.isBatchMode() && this.ic != null && this.ic.getDisplayList() != null) {
            return;
        }
        Color c = this.getStrokeColor();
        this.setStrokeColor(TextRoi.getColor());
        super.draw(g);
        this.setStrokeColor(c);
        double mag = this.getMagnification();
        int sx = this.screenXD(this.getXBase());
        int sy = this.screenYD(this.getYBase());
        int swidth = (int)((this.bounds != null ? this.bounds.width : (double)this.width) * mag);
        int sheight = (int)((this.bounds != null ? this.bounds.height : (double)this.height) * mag);
        Rectangle r = null;
        if (this.angle != 0.0) {
            this.drawText(g);
        } else {
            r = g.getClipBounds();
            g.setClip(sx, sy, swidth, sheight);
            this.drawText(g);
            if (r != null) {
                g.setClip(r.x, r.y, r.width, r.height);
            }
        }
    }

    @Override
    public void drawOverlay(Graphics g) {
        this.drawText(g);
    }

    void drawText(Graphics g) {
        g.setColor(this.strokeColor != null ? this.strokeColor : ROIColor);
        Java2.setAntialiasedText(g, this.getAntiAlias());
        double mag = this.getMagnification();
        int xi = (int)Math.round(this.getXBase());
        int yi = (int)Math.round(this.getYBase());
        double widthd = this.bounds != null ? this.bounds.width : (double)this.width;
        double heightd = this.bounds != null ? this.bounds.height : (double)this.height;
        int widthi = (int)Math.round(widthd);
        int heighti = (int)Math.round(heightd);
        Font font = this.getScaledFont();
        FontMetrics metrics = g.getFontMetrics(font);
        int fontHeight = metrics.getHeight();
        int descent = metrics.getDescent();
        g.setFont(font);
        Graphics2D g2d = (Graphics2D)g;
        int sx = this.nonScalable ? xi : this.screenXD(this.getXBase());
        int sy = this.nonScalable ? yi : this.screenYD(this.getYBase());
        int sw = this.nonScalable ? widthi : (int)(this.getMagnification() * widthd);
        int sh = this.nonScalable ? heighti : (int)(this.getMagnification() * heightd);
        AffineTransform at = null;
        if (this.angle != 0.0) {
            at = g2d.getTransform();
            double cx = sx;
            double cy = sy;
            double theta = Math.toRadians(this.angle);
            g2d.rotate(-theta, cx, cy);
        }
        int i = 0;
        if (this.fillColor != null) {
            Color c = g.getColor();
            int alpha = this.fillColor.getAlpha();
            g.setColor(this.fillColor);
            g.fillRect(sx, sy, sw, sh);
            g.setColor(c);
        }
        while (i < 50 && this.theText[i] != null) {
            switch (this.justification) {
                case 0: {
                    g.drawString(this.theText[i], sx, sy + fontHeight - descent);
                    break;
                }
                case 1: {
                    int tw = metrics.stringWidth(this.theText[i]);
                    g.drawString(this.theText[i], sx + (sw - tw) / 2, sy + fontHeight - descent);
                    break;
                }
                case 2: {
                    int tw = metrics.stringWidth(this.theText[i]);
                    g.drawString(this.theText[i], sx + sw - tw, sy + fontHeight - descent);
                }
            }
            ++i;
            sy += fontHeight;
        }
        if (at != null) {
            g2d.setTransform(at);
        }
    }

    public static String getDefaultFontName() {
        return name;
    }

    public static int getDefaultFontSize() {
        return size;
    }

    public static int getDefaultFontStyle() {
        return style;
    }

    public void setFont(Font font) {
        this.font = font;
        this.updateBounds();
    }

    public void setFontSize(int size) {
        if (this.font == null) {
            this.font = defaultFont;
        }
        this.font = this.font.deriveFont((float)size);
    }

    public Font getCurrentFont() {
        return this.font;
    }

    public static boolean isAntialiased() {
        return antialiasedText;
    }

    public static void setAntialiasedText(boolean antialiased) {
        antialiasedText = antialiased;
    }

    public void setAntialiased(boolean antiAlias) {
        this.setAntiAlias(antiAlias);
        if (this.angle > 0.0) {
            this.setAntiAlias(true);
        }
    }

    public boolean getAntialiased() {
        return this.getAntiAlias();
    }

    public static void setGlobalJustification(int justification) {
        Roi roi;
        if (justification < 0 || justification > 2) {
            justification = 0;
        }
        globalJustification = justification;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null && (roi = imp.getRoi()) instanceof TextRoi) {
            ((TextRoi)roi).setJustification(justification);
            imp.draw();
        }
    }

    public static int getGlobalJustification() {
        return globalJustification;
    }

    public void setJustification(int justification) {
        if (justification < 0 || justification > 2) {
            justification = 0;
        }
        this.justification = justification;
        this.updateBounds();
        if (this.imp != null) {
            this.imp.draw();
        }
    }

    public int getJustification() {
        return this.justification;
    }

    public static void setFont(String fontName, int fontSize, int fontStyle) {
        TextRoi.setFont(fontName, fontSize, fontStyle, true);
    }

    public static void setFont(String fontName, int fontSize, int fontStyle, boolean antialiased) {
        Roi roi;
        name = fontName;
        size = fontSize;
        style = fontStyle;
        globalJustification = 0;
        antialiasedText = antialiased;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null && (roi = imp.getRoi()) instanceof TextRoi) {
            roi.setAntiAlias(antialiased);
            ((TextRoi)roi).setCurrentFont(new Font(name, style, size));
            imp.draw();
        }
    }

    public static void setDefaultFont(Font font) {
        defaultFont = font;
    }

    public static void setDefaultFontSize(int size) {
        defaultFont = defaultFont.deriveFont((float)size);
    }

    public static void setDefaultFillColor(Color fillColor) {
        defaultFillColor = fillColor;
    }

    public static void setDefaultAngle(double angle) {
        defaultAngle = angle;
    }

    @Override
    protected void handleMouseUp(int screenX, int screenY) {
        super.handleMouseUp(screenX, screenY);
        if (this.width < 5 && this.height < 5 && this.imp != null && this.previousRoi == null) {
            int ox = this.ic != null ? this.ic.offScreenX(screenX) : screenX;
            int oy = this.ic != null ? this.ic.offScreenY(screenY) : screenY;
            TextRoi roi = new TextRoi(ox, oy, line1a);
            roi.setStrokeColor(Toolbar.getForegroundColor());
            roi.firstChar = true;
            this.imp.setRoi(roi);
            return;
        }
        if (this.firstMouseUp) {
            this.updateBounds();
            this.updateText();
            this.firstMouseUp = false;
        }
        if (this.width < 5 || this.height < 5) {
            this.imp.deleteRoi();
        }
    }

    private void updateBounds() {
        if (this.firstChar) {
            return;
        }
        double lineHeight = 0.0;
        double mag = this.getMagnification();
        Font font = this.getScaledFont();
        Graphics g = this.getFontGraphics(font);
        Java2.setAntialiasedText(g, this.getAntiAlias());
        FontMetrics metrics = g.getFontMetrics(font);
        double fontHeight = (double)metrics.getHeight() / mag;
        int nLines = 0;
        Rectangle2D.Double b = this.getFloatBounds();
        double newWidth = 10.0;
        for (int i = 0; i < 50 && this.theText[i] != null; ++i) {
            ++nLines;
            double w = this.stringWidth(this.theText[i], metrics, g) / mag;
            if (!(w > newWidth)) continue;
            newWidth = w;
        }
        b.width = newWidth += 2.0;
        switch (this.justification) {
            case 0: {
                break;
            }
            case 1: {
                b.x = (double)(this.oldX + this.oldWidth) - newWidth / 2.0;
                break;
            }
            case 2: {
                b.x = (double)(this.oldX + this.oldWidth) - newWidth;
            }
        }
        b.height = (double)nLines * fontHeight + 2.0;
        this.setBounds(b);
    }

    private Graphics getFontGraphics(Font font) {
        if (this.fontGraphics == null) {
            BufferedImage bi = new BufferedImage(1, 1, 1);
            this.fontGraphics = (Graphics2D)bi.getGraphics();
        }
        this.fontGraphics.setFont(font);
        return this.fontGraphics;
    }

    void updateText() {
        if (this.imp != null) {
            this.updateClipRect();
            if (this.angle != 0.0) {
                this.imp.draw();
            } else {
                this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
            }
        }
    }

    double stringWidth(String s, FontMetrics metrics, Graphics g) {
        Rectangle2D r = metrics.getStringBounds(s, g);
        return r.getWidth();
    }

    public String getMacroCode(String cmd, ImagePlus imp) {
        String code = "";
        boolean script = Recorder.scriptMode();
        boolean addSelection = cmd.startsWith("Add");
        if (script && !addSelection) {
            code = code + "ip = imp.getProcessor();\n";
        }
        if (script) {
            String str = "Font.PLAIN";
            if (style == 1) {
                str = "Font.BOLD";
            } else if (style == 2) {
                str = "Font.ITALIC";
            }
            code = code + "font = new Font(\"" + name + "\", " + str + ", " + size + ");\n";
            if (addSelection) {
                return this.getAddSelectionScript(code);
            }
            code = code + "ip.setFont(font);\n";
        } else {
            String options = "";
            if (style == 1) {
                options = options + "bold";
            }
            if (style == 2) {
                options = options + " italic";
            }
            if (antialiasedText) {
                options = options + " antialiased";
            }
            if (options.equals("")) {
                options = "plain";
            }
            code = code + "setFont(\"" + name + "\", " + size + ", \"" + options + "\");\n";
        }
        ImageProcessor ip = imp.getProcessor();
        ip.setFont(new Font(name, style, size));
        FontMetrics metrics = ip.getFontMetrics();
        int fontHeight = metrics.getHeight();
        code = script ? code + "ip.setColor(new Color(" + this.getColorArgs(this.getStrokeColor()) + "));\n" : code + "setColor(\"" + Colors.colorToString(this.getStrokeColor()) + "\");\n";
        if (addSelection) {
            code = code + "Overlay.drawString(\"" + this.text() + "\", " + this.x + ", " + (this.y + fontHeight) + ", " + this.getAngle() + ");\n";
            code = code + "Overlay.show();\n";
        } else {
            code = code + (script ? "ip." : "") + "drawString(\"" + this.text() + "\", " + this.x + ", " + (this.y + fontHeight) + ");\n";
            code = script ? code + "imp.updateAndDraw();\n" : code + "//makeText(\"" + this.text() + "\", " + this.x + ", " + (this.y + fontHeight) + ");\n";
        }
        return code;
    }

    private String text() {
        String text = "";
        for (int i = 0; i < 50 && this.theText[i] != null; ++i) {
            text = text + this.theText[i];
            if (this.theText[i + 1] == null) continue;
            text = text + "\\n";
        }
        return text;
    }

    private String getAddSelectionScript(String code) {
        int just;
        code = code + "roi = new TextRoi(" + this.x + ", " + this.y + ", \"" + this.text() + "\", font);\n";
        code = code + "roi.setStrokeColor(new Color(" + this.getColorArgs(this.getStrokeColor()) + "));\n";
        if (this.getFillColor() != null) {
            code = code + "roi.setFillColor(new Color(" + this.getColorArgs(this.getFillColor()) + "));\n";
        }
        if ((just = this.getJustification()) > 0) {
            if (just == 1) {
                code = code + "roi.setJustification(TextRoi.CENTER);\n";
            } else if (just == 2) {
                code = code + "roi.setJustification(TextRoi.RIGHT);\n";
            }
        }
        if (this.getAngle() != 0.0) {
            code = code + "roi.setAngle(" + this.getAngle() + ");\n";
        }
        code = code + "overlay.add(roi);\n";
        return code;
    }

    private String getColorArgs(Color c) {
        return IJ.d2s((double)c.getRed() / 255.0, 2) + ", " + IJ.d2s((double)c.getGreen() / 255.0, 2) + ", " + IJ.d2s((double)c.getBlue() / 255.0, 2);
    }

    public String getText() {
        String text = "";
        for (int i = 0; i < 50 && this.theText[i] != null; ++i) {
            text = text + this.theText[i] + "\n";
        }
        return text;
    }

    public void setText(String text) {
        String[] lines = Tools.split(text, "\n");
        boolean changes = false;
        for (int i = 0; i < Math.min(lines.length, this.theText.length - 1); ++i) {
            if (lines[i].equals(this.theText[i])) continue;
            this.theText[i] = lines[i];
            changes = true;
        }
        if (lines.length < this.theText.length && this.theText[lines.length] != null) {
            this.theText[lines.length] = null;
            changes = true;
        }
        if (changes) {
            this.firstChar = false;
            this.updateBounds();
        }
    }

    @Override
    public boolean isDrawingTool() {
        return true;
    }

    public void clear(ImageProcessor ip) {
        if (this.font == null) {
            ip.fill();
        } else {
            ip.setFont(this.font);
            ip.setAntialiasedText(antialiasedText);
            int w = 0;
            for (int i = 0; i < 50 && this.theText[i] != null; ++i) {
                int w2 = ip.getStringWidth(this.theText[i]);
                if (w2 > w) {
                    // empty if block
                }
                w = w2;
            }
            Rectangle r = ip.getRoi();
            if (w > r.width) {
                r.width = w;
                ip.setRoi(r);
            }
            ip.fill();
        }
    }

    @Override
    public void setLocation(int x, int y) {
        super.setLocation(x, y);
        this.oldWidth = this.width;
    }

    @Override
    public synchronized Object clone() {
        TextRoi tr = (TextRoi)super.clone();
        tr.theText = new String[50];
        for (int i = 0; i < 50; ++i) {
            tr.theText[i] = this.theText[i];
        }
        return tr;
    }

    @Override
    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
        if (angle != 0.0) {
            this.setAntiAlias(true);
        }
    }

    public boolean getDrawStringMode() {
        return false;
    }

    public void setDrawStringMode(boolean drawStringMode) {
    }

    public void setPreviousTextRoi(Roi previousRoi) {
        this.previousRoi = previousRoi;
    }

    public static String getFont() {
        return name;
    }

    public static int getSize() {
        return size;
    }

    public static int getStyle() {
        return style;
    }

    public void setCurrentFont(Font font) {
        this.font = font;
        this.updateBounds();
    }

    static {
        firstTime = true;
        defaultFont = IJ.font12;
    }
}

