/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageWindow;
import ij.gui.PolygonRoi;
import ij.measure.Calibration;
import ij.plugin.frame.Recorder;
import ij.process.FloatPolygon;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class RotatedRectRoi
extends PolygonRoi {
    private double xstart;
    private double ystart;
    private static double DefaultRectWidth = 50.0;
    private double rectWidth = DefaultRectWidth;

    public RotatedRectRoi(double x1, double y1, double x2, double y2, double rectWidth) {
        super(new float[5], new float[5], 5, 3);
        this.rectWidth = rectWidth;
        this.makeRectangle(x1, y1, x2, y2);
        this.state = 3;
        this.bounds = null;
    }

    public RotatedRectRoi(int sx, int sy, ImagePlus imp) {
        super(sx, sy, imp);
        int pixels;
        this.type = 3;
        this.xstart = this.offScreenXD(sx);
        this.ystart = this.offScreenYD(sy);
        ImageWindow win = imp.getWindow();
        int n = pixels = win != null ? (int)((double)win.getSize().height / win.getCanvas().getMagnification()) : imp.getHeight();
        if (IJ.debugMode) {
            IJ.log("RotatedRectRoi: " + (int)this.rectWidth + " " + pixels);
        }
        if (this.rectWidth > (double)pixels) {
            this.rectWidth = pixels / 3;
        }
        this.setDrawOffset(false);
        this.bounds = null;
    }

    @Override
    public void draw(Graphics g) {
        super.draw(g);
        if (!this.overlay && this.ic != null) {
            double mag = this.ic.getMagnification();
            for (int i = 0; i < 4; ++i) {
                this.handleColor = i == 3 ? (this.strokeColor != null ? this.strokeColor : ROIColor) : Color.white;
                this.drawHandle(g, this.hxs(i), this.hys(i));
            }
        }
    }

    private int hxs(int index) {
        int indexPlus1 = index < 3 ? index + 1 : 0;
        return this.xp2[index] + (this.xp2[indexPlus1] - this.xp2[index]) / 2;
    }

    private int hys(int index) {
        int indexPlus1 = index < 3 ? index + 1 : 0;
        return this.yp2[index] + (this.yp2[indexPlus1] - this.yp2[index]) / 2;
    }

    private double hx(int index) {
        int indexPlus1 = index < 3 ? index + 1 : 0;
        return this.xpf[index] + (this.xpf[indexPlus1] - this.xpf[index]) / 2.0f + (float)this.x;
    }

    private double hy(int index) {
        int indexPlus1 = index < 3 ? index + 1 : 0;
        return this.ypf[index] + (this.ypf[indexPlus1] - this.ypf[index]) / 2.0f + (float)this.y;
    }

    @Override
    protected void grow(int sx, int sy) {
        double x1 = this.xstart;
        double y1 = this.ystart;
        double x2 = this.offScreenXD(sx);
        double y2 = this.offScreenYD(sy);
        this.makeRectangle(x1, y1, x2, y2);
        this.imp.draw();
    }

    void makeRectangle(double x1, double y1, double x2, double y2) {
        double length = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        double angle = Math.atan((x2 - x1) / (y2 - y1));
        double wsa = this.rectWidth / 2.0 * Math.sin(1.5707963267948966 + angle);
        double wca = this.rectWidth / 2.0 * Math.cos(1.5707963267948966 + angle);
        this.nPoints = 5;
        this.xpf[3] = (float)(x1 - wsa);
        this.ypf[3] = (float)(y1 - wca);
        this.xpf[0] = (float)(x1 + wsa);
        this.ypf[0] = (float)(y1 + wca);
        this.xpf[1] = (float)(x2 + wsa);
        this.ypf[1] = (float)(y2 + wca);
        this.xpf[2] = (float)(x2 - wsa);
        this.ypf[2] = (float)(y2 - wca);
        this.xpf[4] = this.xpf[0];
        this.ypf[4] = this.ypf[0];
        this.makePolygonRelative();
        this.cachedMask = null;
        DefaultRectWidth = this.rectWidth;
        this.showStatus();
    }

    @Override
    public void showStatus() {
        Calibration cal;
        double[] p = this.getParams();
        double dx = p[2] - p[0];
        double dy = p[3] - p[1];
        double length = Math.sqrt(dx * dx + dy * dy);
        double width = p[4];
        if (this.imp != null && !IJ.altKeyDown() && (cal = this.imp.getCalibration()).scaled() && cal.pixelWidth == cal.pixelHeight) {
            length = Math.sqrt((dx *= cal.pixelWidth) * dx + (dy *= cal.pixelHeight) * dy);
            width = p[4] * cal.pixelWidth;
        }
        double angle = this.getFloatAngle(p[0], p[1], p[2], p[3]);
        IJ.showStatus("length=" + IJ.d2s(length) + ", width=" + IJ.d2s(width) + ", angle=" + IJ.d2s(angle));
    }

    @Override
    public void nudgeCorner(int key) {
        if (this.ic == null) {
            return;
        }
        double[] p = this.getParams();
        double x1 = p[0];
        double y1 = p[1];
        double x2 = p[2];
        double y2 = p[3];
        double inc = 1.0 / this.ic.getMagnification();
        switch (key) {
            case 38: {
                y2 -= inc;
                break;
            }
            case 40: {
                y2 += inc;
                break;
            }
            case 37: {
                x2 -= inc;
                break;
            }
            case 39: {
                x2 += inc;
            }
        }
        this.makeRectangle(x1, y1, x2, y2);
        this.imp.draw();
        this.notifyListeners(2);
        this.showStatus();
    }

    void makePolygonRelative() {
        FloatPolygon poly = new FloatPolygon(this.xpf, this.ypf, this.nPoints);
        Rectangle r = poly.getBounds();
        this.x = r.x;
        this.y = r.y;
        this.width = r.width;
        this.height = r.height;
        this.bounds = null;
        for (int i = 0; i < this.nPoints; ++i) {
            this.xpf[i] = this.xpf[i] - (float)this.x;
            this.ypf[i] = this.ypf[i] - (float)this.y;
        }
    }

    @Override
    protected void handleMouseUp(int screenX, int screenY) {
        this.nPoints = 4;
        this.state = 3;
        if (Recorder.record) {
            double[] p = this.getParams();
            if (Recorder.scriptMode()) {
                Recorder.recordCall("imp.setRoi(new RotatedRectRoi(" + (int)p[0] + "," + (int)p[1] + "," + (int)p[2] + "," + (int)p[3] + "," + (int)p[4] + "));");
            } else {
                Recorder.record("makeRotatedRectangle", (int)p[0], (int)p[1], (int)p[2], (int)p[3], (int)p[4]);
            }
        }
    }

    @Override
    protected void moveHandle(int sx, int sy) {
        double ox = this.offScreenXD(sx);
        double oy = this.offScreenYD(sy);
        double x1 = this.hx(3);
        double y1 = this.hy(3);
        double x2 = this.hx(1);
        double y2 = this.hy(1);
        switch (this.activeHandle) {
            case 0: {
                double dx = this.hx(2) - ox;
                double dy = this.hy(2) - oy;
                this.rectWidth = Math.sqrt(dx * dx + dy * dy);
                break;
            }
            case 1: {
                x2 = ox;
                y2 = oy;
                break;
            }
            case 2: {
                double dx = this.hx(0) - ox;
                double dy = this.hy(0) - oy;
                this.rectWidth = Math.sqrt(dx * dx + dy * dy);
                break;
            }
            case 3: {
                x1 = ox;
                y1 = oy;
            }
        }
        this.makeRectangle(x1, y1, x2, y2);
        this.imp.draw();
    }

    @Override
    public int isHandle(int sx, int sy) {
        int size = this.getHandleSize() + 5;
        int halfSize = size / 2;
        int index = -1;
        for (int i = 0; i < 4; ++i) {
            int sx2 = Math.round(this.hxs(i) - halfSize);
            int sy2 = Math.round(this.hys(i) - halfSize);
            if (sx < sx2 || sx > sx2 + size || sy < sy2 || sy > sy2 + size) continue;
            index = i;
            break;
        }
        return index;
    }

    public double[] getParams() {
        double[] params = new double[]{this.hx(3), this.hy(3), this.hx(1), this.hy(1), this.rectWidth};
        return params;
    }

    @Override
    public boolean subPixelResolution() {
        return true;
    }
}

