from sqlalchemy import create_engine
from sqlalchemy.ext.declarative import declarative_base
from sqlalchemy import Column, Integer, String, ForeignKey
from sqlalchemy.orm import sessionmaker, relationship

# Create a new Engine instance. 
engine = create_engine('sqlite:///example_3.db')


# Construct a base class for declarative class definitions
# and bind it to engine
Base = declarative_base(engine)

# Declarative mapping for Client
class Client(Base):
    __tablename__ = 'client'
 
    id = Column(Integer, primary_key=True)
    address = Column(String)
    type = Column(String)

    __mapper_args__ = {
        'polymorphic_identity':'client',
        'polymorphic_on':type
        }

# Declarative mapping for Person
class Person(Client):
    __tablename__ = 'person'

    id = Column(Integer, ForeignKey('client.id'), primary_key=True)
    name = Column(String)
    surname = Column(String)

    __mapper_args__ = {
        'polymorphic_identity':'person',
    }

# Declarative mapping for Company
class Company(Client):
    __tablename__ = 'company'

    id = Column(Integer, ForeignKey('client.id'), primary_key=True)
    company_name = Column(String)
    industry = Column(String)

    client = relationship("Client")

    __mapper_args__ = {
        'polymorphic_identity':'company',
    }

# Create a configurable Session factory.
Session = sessionmaker(bind=engine)
