from sqlalchemy import create_engine, event
from sqlalchemy.engine import Engine
from sqlalchemy.ext.declarative import declarative_base
from sqlalchemy import Column, Integer, String, ForeignKey
from sqlalchemy.orm import sessionmaker, relationship

from sqlite3 import Connection as SQLite3Connection

# Create a new Engine instance. 
engine = create_engine('sqlite:///example_2.db')


# Construct a base class for declarative class definitions
# and bind it to engine
Base = declarative_base(engine)

# Declarative mapping for Author and Book classes
class Author(Base):
    __tablename__ = "author"

    id = Column(Integer, primary_key=True)
    name = Column(String)  

    book = relationship("Book")

class Book(Base):
    __tablename__ = "book"

    id = Column(Integer, primary_key=True)
    title = Column(String)      
    author_id = Column(Integer, ForeignKey("author.id"))

    author = relationship("Author")

# Enable foreign key constraint in SQLite
@event.listens_for(Engine, "connect")
def _set_sqlite_pragma(dbapi_connection, connection_record):
    if isinstance(dbapi_connection, SQLite3Connection):
        cursor = dbapi_connection.cursor()
        cursor.execute("PRAGMA foreign_keys=ON;")
        cursor.close()

# Create a configurable Session factory.
Session = sessionmaker(bind=engine)
