from sqlalchemy import create_engine
from sqlalchemy.ext.declarative import declarative_base
from sqlalchemy.orm import sessionmaker

from sqlalchemy import Column, Integer, String


# Create a new Engine instance. 
engine = create_engine('sqlite:///example_1.db')


# Construct a base class for declarative class definitions
# and bind it to engine
Base = declarative_base(engine)


# Declarative mapping for Car
class Car(Base):
    __tablename__ = "car"
 
    id = Column(Integer, primary_key=True)
    name = Column(String)  
    price = Column(Integer)


# Create a configurable Session factory.
Session = sessionmaker(bind=engine)
