#!/usr/bin/env python
# -*- coding: utf-8 -*-

from mapping import Car
from mapping import Session
from sqlalchemy.sql import and_ 

# Create a Session object
session = Session()

# Query cars with name ending with 'en'
results = session.query(Car).filter(Car.name.like('%en'))

# Print the results
print("Cars with name ending with 'en' are:")
for car in results:
    print(car.name)
print()

# Query cars filtered by id
results = session.query(Car).filter(Car.id.in_([2, 4, 6, 8]))

# Print the results
print("Cars with id in [2, 4, 6, 8] are:")
for car in results:
    print(car.id, car.name)
print()

# Query cars filtered by price
results = session.query(Car).filter(and_(Car.price > 10000,
	                                     Car.price < 40000))

# Print the results
print("Cars with price between 10000 and 40000 are:")
for car in results:
    print(car.name, car.price)


# Close session
session.close()
