from django.db import models
from phonenumber_field.modelfields import PhoneNumberField
from django.core.validators import MaxValueValidator, MinValueValidator

# Create your models here.

SEX = ('M', 'F')
MARITAL_STATUS = ('celibe', 'coniugato', 'vedovo', 'separato', 'divorziato')
WHEEL_NUMBER = (2,4)
FAMILY_REPORTS = ('primo', 'secondo', 'terzo')
BONUSMALUS_CLASS = (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18)


class Client(models.Model):
    name = models.CharField(max_length = 20)
    surname = models.CharField(max_length = 20)
    fiscalCode =  models.CharField(max_length = 16, primary_key = True)
    residenceRoad = models.CharField(max_length = 30)
    streetNumber = models.CharField(max_length = 5)
    bithDay = models.DateField()
    sex = models.CharField(max_length=1, choices = [(d,d) for d in SEX])
    profession = models.CharField(max_length = 50)
    maritalStatus = models.CharField(max_length = 10, choices = [(d,d) for d in MARITAL_STATUS])
    phoneNumber = PhoneNumberField(blank = True, null = True)
    email = models.EmailField(max_length = 70, blank = True, null = True)

    def __str__(self):
        return "{}, {}, {}".format(self.name, self.surname, self.fiscalCode)
    class Meta:
        ordering = ['surname']


class Vehicle(models.Model):
    licensePlate = models.CharField(max_length = 7, primary_key = True)
    fiscalCode = models.ForeignKey(Client, on_delete = models.CASCADE)
    engineSize = models.PositiveIntegerField()
    model = models.CharField(max_length = 50)
    kmTraveled = models.CharField(max_length = 20)
    wheelNumber = models.PositiveSmallIntegerField(choices = [(d,d) for d in WHEEL_NUMBER])

    def __str__(self):
        return self.licensePlate


class BMClass(models.Model):
    BMClass = models.PositiveSmallIntegerField(choices = [(d,d) for d in BONUSMALUS_CLASS], primary_key = True)
    basePremium = models.FloatField()

    def __str__(self):
        return "{}, {}".format(self.BMClass, self.basePremium)


class Contract(models.Model):
    contractId = models.CharField(max_length=15, primary_key = True)
    date = models.DateTimeField(auto_now_add = True)
    clientFiscalCode = models.ForeignKey(Client, on_delete = models.CASCADE)
    licensePlate = models.ForeignKey(Vehicle, on_delete = models.CASCADE)
    renewal = models.BooleanField()
    classBM = models.ForeignKey(BMClass, null = True, on_delete = models.SET_NULL)
    totalPremium = models.FloatField(blank = True)

    def __str__(self):
        return "{} on {}".format(self.clientFiscalCode, self.date.strftime('%d-%m-%Y'))


class FamilyReports(models.Model):
    fiscalCode1 = models.ForeignKey(Client, on_delete = models.CASCADE, related_name = "primo")
    fiscalCode2 = models.ForeignKey(Client, on_delete = models.CASCADE, related_name = "secondo")
    relationship = models.CharField(max_length=7, choices = [(d,d) for d in FAMILY_REPORTS])

    class Meta:
        unique_together = (("fiscalCode1", "fiscalCode2"),)

    def __str__(self):
        return self.relationship


class Claims(models.Model):
    licensePlate = models.ForeignKey(Vehicle, on_delete = models.CASCADE)
    totalCompensation = models.FloatField()
    date = models.DateTimeField(auto_now_add = True)
    location = models.CharField(max_length = 30)
    responsibility = models.FloatField(validators = [MinValueValidator(0), MaxValueValidator(100)])
    compensationTimeDays = models.PositiveIntegerField(blank = True)
    counterpartLicensePlate = models.CharField(max_length = 7)
    counterpartInsuranceCompany = models.CharField(max_length = 50)
    photo = models.ImageField(blank = True, null = True)

    def __str__(self):
        return "{} paid {}".format(self.licensePlate, self.totalCompensation)


class BlackBox(models.Model):
    blackBoxId = models.CharField(max_length=10, primary_key = True)
    licensePlate = models.ForeignKey(Vehicle, on_delete = models.CASCADE)
    clientFiscalCode = models.ForeignKey(Client, on_delete = models.CASCADE)
    observationDate = models.DateTimeField(auto_now_add = True)
    kmTraveled = models.FloatField(blank = True)
    timeTraveledSeconds = models.FloatField(blank = True)
    provinceTraveled = models.CharField(max_length = 30)
    nationTraveled =  models.CharField(max_length = 30)
    hourStarting = models.TimeField(auto_now = True)
    hourClosing = models.TimeField(auto_now = True)
    maxVelocity = models.PositiveSmallIntegerField(blank = True)
    timeVelocityOverLimig = models.FloatField(blank = True)
    kmVelocityOverLimit  = models.FloatField(blank = True)
    totalTime = models.FloatField( blank = True)

    def __str__(self):
        return self.BlackBoxId


class Office(models.Model):
    officeId = models.AutoField(primary_key = True)
    location = models.CharField(max_length = 30)

    def __str__(self):
        return "{}, {}".format(self.officeId, self.location)


class Agent(models.Model):
    name = models.CharField(max_length = 20)
    surname = models.CharField(max_length = 20)
    fiscalCode =  models.CharField(max_length = 16, primary_key = True)
    agentId =  models.IntegerField(unique = True)
    officeId = models.ForeignKey(Office, default = '', on_delete = models.SET_DEFAULT)

    def __str__(self):
        return "{}, {}, {}".format(self.name, self.surname, self.fiscalCode)
    class Meta:
        ordering = ['surname']


