from django.contrib import admin
from django.db import models
from .models import Client, Vehicle, Contract, FamilyReports, BMClass, Claims, BlackBox, Agent, Office

class ClientAdmin(admin.ModelAdmin):
    model = Client
    list_display = ('name', 'surname', 'fiscalCode', 'email', 'phoneNumber')

class VehicleAdmin(admin.ModelAdmin):
    model = Vehicle
    list_display = ('licensePlate', 'fiscalCode', 'model')

class ContractAdmin(admin.ModelAdmin):
    model = Contract
    list_display = ('contractId', 'classBM', 'date', 'clientFiscalCode', 'licensePlate', 'renewal')

class FamilyReportsAdmin(admin.ModelAdmin):
    model = FamilyReports
    list_display = ('fiscalCode1', 'fiscalCode2', 'relationship')

class BMClassAdmin(admin.ModelAdmin):
    model = BMClass
    list_display = ('BMClass', 'basePremium')

class ClaimsAdmin(admin.ModelAdmin):
    model = Claims
    list_display = ('licensePlate', 'totalCompensation', 'date', 'location', 'responsibility', 'compensationTimeDays')

class BlackBoxAdmin(admin.ModelAdmin):
    model = BlackBox
    list_display = ('licensePlate', 'clientFiscalCode', 'blackBoxId')

class AgentAdmin(admin.ModelAdmin):
    model = Agent
    list_display = ('name', 'surname', 'fiscalCode', 'agentId', 'officeId')

class OfficeAdmin(admin.ModelAdmin):
    model = Office
    list_display = ('officeId', 'location')


admin.site.register(Client, ClientAdmin)
admin.site.register(Vehicle, VehicleAdmin)
admin.site.register(Contract, ContractAdmin)
admin.site.register(FamilyReports, FamilyReportsAdmin)
admin.site.register(BMClass, BMClassAdmin)
admin.site.register(Claims, ClaimsAdmin)
admin.site.register(BlackBox, BlackBoxAdmin)
admin.site.register(Agent, AgentAdmin)
admin.site.register(Office, OfficeAdmin)
