# Django Example

Create the anaconda environment for this example

    conda create -n insurance django

To activate this environment, use

    conda activate insurance

Additional packages are needed, not available in Anaconda but installed with the `pip` command

    pip install django-extensions
    pip install django-phonenumber-field phonenumbers
    pip install Pillow

To deactivate an active environment, use

    conda deactivate

## Create a Django Project

Run the following commands

    django-admin startproject insurance
    cd insurance
    python manage.py startapp insurancedb

which create a project folder, named insurance, with additional files and then an application, named insurancedb, inside the project.
It automatically creates skeleton files needed by a Django project and application.

Copy the `admin.py` and `models.py` files to the `insurancedb` folder

    cp ../admin.py insurancedb/
    cp ../models.py insurancedb/

and copy the `urls.py` and `views.py` file to the `insurance` folder

    cp ../urls.py insurance/
    cp ../views.py insurance/

Edit the `insurance/setting.py` file adding in the `INSTALLED_APPS` list
two more elements: `django_extensions` and `insurancedb`. Then your
application definition should appear like this

    INSTALLED_APPS = [
        'django.contrib.admin',
        'django.contrib.auth',
        'django.contrib.contenttypes',
        'django.contrib.sessions',
        'django.contrib.messages',
        'django.contrib.staticfiles',
        'django_extensions',
        'insurancedb',
    ]

Finally, generate a migration and migrate

    python manage.py makemigrations
    python manage.py migrate

Insert some data

    python manage.py shell < ../insert.py

Create an admin user

    python manage.py createsuperuser

Run the Django web server

    python manage.py runserver

Access to <http://127.0.0.1:8000>.
