from django.shortcuts import render

# Create your views here.

from rest_framework import viewsets
from imagedb.serializers import InstrumentSerializer, NispDetectorSerializer, NispRawFrameSerializer
from imagedb.models import Instrument, NispDetector, NispRawFrame
from django_ufilter.filtersets import ModelFilterSet


class InstrumentViewSet(viewsets.ReadOnlyModelViewSet):
  queryset = Instrument.objects.all()
  serializer_class = InstrumentSerializer
  
class NispDetectorViewSet(viewsets.ReadOnlyModelViewSet):
  queryset = NispDetector.objects.all()
  serializer_class = NispDetectorSerializer



class NispRawFrameFilterSet(ModelFilterSet):
  class Meta:
    model = NispRawFrame
    fields = [f.name for f in NispRawFrame._meta.get_fields() 
              if not hasattr(f, 'subfields')]
    
  
class NispRawFrameViewSet(viewsets.ReadOnlyModelViewSet):
  queryset = NispRawFrame.objects.all()
  serializer_class = NispRawFrameSerializer
  filter_class = NispRawFrameFilterSet
  


