from django.urls import re_path, include
from rest_framework.routers import DefaultRouter

from imagedb import views

router = DefaultRouter()
router.register(r'instruments', views.InstrumentViewSet)
router.register(r'nisprawframes', views.NispRawFrameViewSet)
router.register(r'nispdetectors', views.NispDetectorViewSet)

urlpatterns = [
  re_path(r'^', include(router.urls))
]
