
from rest_framework import serializers
from composite_field.rest_framework_support import CompositeFieldSerializer


from imagedb.models import Instrument, NispDetector, Astrometry, NispRawFrame

class InstrumentSerializer(serializers.ModelSerializer):
  class Meta:
    model = Instrument
    fields = '__all__'
    
    
class AstrometrySerializer(serializers.ModelSerializer):
  ctype1 = CompositeFieldSerializer()
  ctype2 = CompositeFieldSerializer()
  
  class Meta:
    model = Astrometry
    exclude = [f.name for g in Astrometry._meta.get_fields() 
               if hasattr(g, 'subfields') 
               for f in g.subfields.values()] 

    
class NispDetectorSerializer(serializers.ModelSerializer):
  astrometry = AstrometrySerializer()

  class Meta:
    model = NispDetector
    exclude = ('rawFrame',)
    
    
class NispRawFrameSerializer(serializers.ModelSerializer):
  detectors = NispDetectorSerializer(many = True, read_only = True)
  commandedPointing = CompositeFieldSerializer()
  imageType = CompositeFieldSerializer()

  class Meta:
    model = NispRawFrame
    exclude = [f.name for g in NispRawFrame._meta.get_fields() 
               if hasattr(g, 'subfields') 
               for f in g.subfields.values()]
    depth = 2
    
    
