# Copyright (C) 2020 INAF
# This software is distributed under the terms of the BSD-3-Clause license
#
# Authors:
#    Bulgarelli Andrea <andrea.bulgarelli@inaf.it>
#    Baroncelli Leonardo <leonardo.baroncelli@inaf.it>
#    Parmiggiani Nicolò <nicolo.parmiggiani@inaf.it>
#    Addis Antonio <antonio.addis@inaf.it>

import UTILITY_MODULE
import UTILITY_MODULE__POA

from Acspy.Servants.ContainerServices import ContainerServices

from Acspy.Clients.SimpleClient import PySimpleClient

""" !!!!
A quanto pare le classi che non ereditano da ACSComponent non possono lanciare eccezioni
"""

class Singleton(type):
    _instances = {}
    def __call__(cls, *args, **kwargs):
        if cls not in cls._instances:
            cls._instances[cls] = super(Singleton, cls).__call__(*args, **kwargs)
        return cls._instances[cls]

class ContainerUtility(UTILITY_MODULE__POA.ContainerUtility, ContainerServices):

    def __init__(self):
        __metaclass__ = Singleton
        ContainerServices.__init__(self)
        self._logger = self.getLogger()
        self.acsPySimpleClient = PySimpleClient()

    def checkIfActive(self, componentName):    

        """ TODO
        L'uso di PySimpleClient() è superfluo, il metodo availableComponents() è già parte di questa classe perchè viene eridatato da ContainerServices. 
        La chiamata a quel metodo però da errore...
        """

         # ATTENZIONE: si potrebbe usare la getInstance() MA, chiamata a getInstance() + chiamata a disconnect() + chiamata a getInstance() + chiamata a availableComponents() => ACS ERROR!!  

        availableComponents = self.acsPySimpleClient.availableComponents()
        #availableComponents = self.availableComponents()

        found = False
        isActive = False    
        for ac in availableComponents:
            # self._logger.logInfo("======> [ContainerUtility] Component: "+ac.name+" "+str(ac.reference)+" is not none: "+str(ac.reference is not None))
            if ac.name == componentName:
                # self._logger.logInfo("======> [ContainerUtility] Component "+componentName+" has been found (="+ac.name+")")
                found = True
                if ac.reference is not None:
                    isActive = True
                    # self._logger.logInfo("======> [ContainerUtility] Component: isActive has been set tot True: "+str(isActive))
                break

        # self._logger.logInfo("======> [ContainerUtility] found: "+str(found)+" isActive: "+str(isActive))

        if not found:
            return 0
        elif found and not isActive:
            return 1
        else:
            return 2

    def __del__(self):
        self.acsPySimpleClient.disconnect()
