# Copyright (C) 2020 INAF
# This software is distributed under the terms of the BSD-3-Clause license
#
# Authors:
#    Bulgarelli Andrea <andrea.bulgarelli@inaf.it>
#    Baroncelli Leonardo <leonardo.baroncelli@inaf.it>
#    Parmiggiani Nicolò <nicolo.parmiggiani@inaf.it>
#    Addis Antonio <antonio.addis@inaf.it>

import SAG_CUSTOM_TYPES_MODULE
import SAG_CUSTOM_TYPES_MODULE__POA

from SAG_CUSTOM_TYPES_MODULE import INIT, WORKING, DONE, ERROR


class SAGCallbackImpl(SAG_CUSTOM_TYPES_MODULE__POA.SAGCallback):
    
    def __init__(self):
        self.status = INIT
        self.data = None

    def working(self, data):
        self.status = WORKING
        self.data = data

    def done(self, data):
        self.status = DONE
        self.data = data

    def err(self, data):
        self.status = ERROR
        self.data = data

    def getInfo(self):
        return SAG_CUSTOM_TYPES_MODULE.SAGCallbackData(self.status, self.data)
        