# Copyright (C) 2020 INAF
# This software is distributed under the terms of the BSD-3-Clause license
#
# Authors:
#    Bulgarelli Andrea <andrea.bulgarelli@inaf.it>
#    Baroncelli Leonardo <leonardo.baroncelli@inaf.it>
#    Parmiggiani Nicolò <nicolo.parmiggiani@inaf.it>
#    Addis Antonio <antonio.addis@inaf.it>

import random
from datetime import datetime

import SAG_MODULE
import SAG_MODULE__POA

import SAG_CUSTOM_TYPES_MODULE
import SAG_CUSTOM_TYPES_MODULE__POA

from Acspy.Servants.ACSComponent import ACSComponent
from Acspy.Servants.ComponentLifecycle import ComponentLifecycle
from Acspy.Servants.ContainerServices import ContainerServices

class SAGDataQualityImpl(SAG_MODULE__POA.SAGDataQuality, ACSComponent, ComponentLifecycle, ContainerServices):

    """
    This interface is used to start DATA QUALITY analysis processes. It is used internally within the SAG system.
    """
    
    def __init__(self):
        ACSComponent.__init__(self)
        ContainerServices.__init__(self)
        self._logger = self.getLogger()
        self.sbID = None
        self.status = 0

    ## Lifecycle ##

    def initialize(self):
        #Assign variable values
        #Initialize data
        pass

    def execute(self):
        #Retrieve components
        #Consider ready to receive calls (Change states if appropriate)
        pass

    def cleanUp(self):
        pass

    def aboutToAbort(self):
        #Do any critical clean up
        #Continue with less critical stuff such as releasing components and other activities similar to cleanUp
        pass


    def initializeWithData(self, sbID):
        """
        Initialize the scheduling block ID of the SAGDataQuality component.
        """
        self.sbID=sbID
    
    def start(self):        
        """
        [TBI] Start the data quality analysis process.
        """
        self._logger.logInfo("SAGDataQualityImpl start() TBI")

    def stop(self):
        """
        [TBI] Stop the data quality analysis process.
        """
        self._logger.logInfo("[SAGDataQualityImpl - stop] TBI")

    def startDataProcessing(self):
        """
        [TBI] Tell the data quality analysis process to start to consume data.
        """
        self._logger.logInfo("[SAGDataQualityImpl - startDataProcessing] TBI")

    def stopDataProcessing(self):
        """
        [TBI] Tell the data quality analysis process to stop to consume data.
        """
        self._logger.logInfo("[SAGDataQualityImpl - stopDataProcessing] TBI")

    def getMonitoringInfo(self):
        """
        Return monitoring data of data quality analysis.
        """
        self._logger.logInfo("[SAGDataQualityImpl - getMonitoringInfo]")
        monitoredParamsList = []
        monitoredParamsList.append(SAG_CUSTOM_TYPES_MODULE.MonitoredParam("status", self.status))
        monitoredParamsList.append(SAG_CUSTOM_TYPES_MODULE.MonitoredParam("timestamp", datetime.now().timestamp()))
        monitoredParamsList.append(SAG_CUSTOM_TYPES_MODULE.MonitoredParam("schedulingBlockID", int(self.sbID)))
        monitoredParamsList.append(SAG_CUSTOM_TYPES_MODULE.MonitoredParam("dqStepOneMeanProcessingRate", random.random()*100))
        monitoredParamsList.append(SAG_CUSTOM_TYPES_MODULE.MonitoredParam("dqStepTwoMeanProcessingRate", random.random()*100))        
        return monitoredParamsList

