#!/bin/bash

# set -e REMEMBER ME, LET'S SET THE SCENE, FOR U AND ME 

echo "INTROOT is $INTROOT"

if [ -z "$INTROOT" ]
then
    echo "Please, set \$INTROOT or \$ACS_CDB"
else

    DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

    export ACS_CDB="$DIR/../"
    echo "ACS_CDB is $ACS_CDB"

    junit_tests_report_dir="$DIR/requirements_verification/test_logs/junit_reports"
    mkdir -p "$junit_tests_report_dir"
    rm -f "$junit_tests_report_dir/*"

    coverage_report_dir="$DIR/requirements_verification/test_logs/coverage_reports"
    mkdir -p "$coverage_report_dir"
    rm -f "$coverage_report_dir/*"

    python -m pytest \
            --verbose -x -s \
            --junitxml="$junit_tests_report_dir/sag-supervisor_tests_report.xml" \
            --cov-config=$DIR/requirements_verification/.coveragerc \
            --cov=$INTROOT/lib/python/site-packages/SAG_IMPL_MODULE \
            $DIR/requirements_verification/test_SAGSubArrayPipelinesSupervisor.py 

            

    echo "Code coverage report conversion in JUnit format.."
    coverage xml -o "$coverage_report_dir/coverage_report.xml"

    echo "JUnit test report=$junit_tests_report_dir/sag-supervisor_tests_report.xml"
    echo "Coverage test report=$coverage_report_dir/coverage_report.xml"

fi

