/* 
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.webapp.xmlconfig;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public class UserConfiguration implements Serializable {

    private static final long serialVersionUID = 8512896146526279206L;

    private String role;
    private String username;
    private String password;
    private final List<TapCredentials> credentialsInfo;

    public UserConfiguration() {
        credentialsInfo = new ArrayList<>();
    }

    @XmlAttribute(name = "username")
    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @XmlAttribute(name = "password")
    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void addCredentials(JoinedCredentials credentials) {
        credentialsInfo.add(credentials);
    }

    public void addSeparateCredentials(SeparatedCredentials separateCredentials) {
        credentialsInfo.add(separateCredentials);
    }

    @XmlAttribute(name = "role")
    public String getRole() {
        return role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    @XmlElementWrapper(name = "credentials-configuration")
    @XmlElements({
        @XmlElement(name = "credentials", type = JoinedCredentials.class)
        ,
        @XmlElement(name = "separated-credentials", type = SeparatedCredentials.class)
    })
    public List<TapCredentials> getCredentialsInfo() {
        return credentialsInfo;
    }
}
