/*
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2017 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.datalayer;

import java.io.Serializable;
import javax.sql.DataSource;

/**
 * Serializable wrapper for a DataSource.
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public class DataSourceWrapper implements Serializable {

    private static final long serialVersionUID = -7658342136473761826L;

    private Credentials credentials;
    private transient DataSource dataSource;

    private DataSourceWrapper() {
    }

    public DataSourceWrapper(Credentials credentials) {
        this.credentials = credentials;
    }

    public DataSource getDataSource() {
        if (dataSource == null) {
            String driverClassName, url;
            switch (credentials.getDatabaseType()) {
                case MYSQL:
                    driverClassName = "com.mysql.jdbc.Driver";
                    url = String.format("jdbc:mysql://%s:%s", credentials.getHostname(), credentials.getPort());
                    break;
                case POSTGRES:
                    driverClassName = "org.postgresql.Driver";
                    url = String.format("jdbc:postgresql://%s:%s/%s",
                            credentials.getHostname(), credentials.getPort(), credentials.getDatabase());
                    break;
                default:
                    throw new UnsupportedOperationException(credentials.getDatabaseType() + " not supported yet.");
            }

            org.apache.tomcat.jdbc.pool.DataSource ds = new org.apache.tomcat.jdbc.pool.DataSource();
            ds.setDriverClassName(driverClassName);
            ds.setUrl(url);
            ds.setUsername(credentials.getUsername());
            ds.setPassword(credentials.getPassword());
            ds.setInitialSize(5);
            ds.setMaxActive(10);
            ds.setMaxIdle(5);
            ds.setMinIdle(2);

            dataSource = ds;
        }
        return dataSource;
    }

    public DatabaseType getDatabaseType() {
        return credentials.getDatabaseType();
    }

    public Credentials getCredentials() {
        return credentials;
    }
}
