/* 
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.webapp;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.ResponseWriter;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public class CustomPartialResponseWriter extends PartialResponseWriter {

    private final Set<String> componentsToEncode;
    private final Map<String, JSUpdateHandler> customJSUpdates;

    public CustomPartialResponseWriter(ResponseWriter wrapped) {
        super(wrapped);
        componentsToEncode = new HashSet<>();
        customJSUpdates = new HashMap<>();
    }

    @Override
    public void endDocument() throws IOException {
        FacesContext fctx = FacesContext.getCurrentInstance();

        if (!customJSUpdates.isEmpty()) {
            startExtension(Collections.singletonMap("id", "jsupdates"));
            for (Map.Entry<String, JSUpdateHandler> entry : customJSUpdates.entrySet()) {
                String componentId = entry.getKey();
                startElement("jsupdate", null);
                writeAttribute("src", componentId, null);
                write(entry.getValue().getUpdate());
                endElement("jsupdate");
            }
            endExtension();
        }

        if (!componentsToEncode.isEmpty()) {
            startExtension(Collections.singletonMap("id", "htmlupdates"));
            for (String componentId : componentsToEncode) {
                UIComponent component = fctx.getViewRoot().findComponent(componentId);
                startElement("htmlupdate", null);
                writeAttribute("src", componentId, null);
                component.encodeAll(fctx);
                endElement("htmlupdate");
            }
            endExtension();
        }

        super.endDocument();
    }

    public void encodeComponent(String componentId) {
        componentsToEncode.add(componentId);
    }

    public void addCustomJSUpdate(String componentId, JSUpdateHandler updateHandler) {
        customJSUpdates.put(componentId, updateHandler);
    }

    public void addCustomJSUpdate(JSUpdateHandler updateHandler) {
        String sourceComponentId = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("javax.faces.source");
        addCustomJSUpdate(sourceComponentId, updateHandler);
    }

    public static CustomPartialResponseWriter getCurrentInstance() {
        return (CustomPartialResponseWriter) FacesContext.getCurrentInstance().getPartialViewContext().getPartialResponseWriter();
    }
}
