/*
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.webapp;

import it.inaf.ia2.tsm.api.DBWrapper;
import it.inaf.ia2.tsm.api.contract.TapSchema;
import java.io.Serializable;
import java.sql.SQLException;
import javax.enterprise.context.ConversationScoped;
import javax.inject.Inject;
import javax.inject.Named;

/**
 *
 * @author Sonia Zorba <zorba at oats.inaf.it>
 */
@ConversationScoped
@Named("consistency")
public class ConsistencyChecksBean implements Serializable {

    private static final long serialVersionUID = 2883609252747956266L;

    @Inject
    TapSchemaEditingBean tapSchemaEditingBean;

    private DBWrapper dbWrapper;
    private TapSchema tapSchema;

    public void setDbWrapper(DBWrapper dbWrapper) {
        this.dbWrapper = dbWrapper;
    }

    public TapSchema getTapSchema() {
        return tapSchema;
    }

    public void setTapSchema(TapSchema tapSchema) {
        this.tapSchema = tapSchema;
    }

    public String proceed() throws SQLException {
        tapSchema.getConsistencyChecks().amendTapSchema(dbWrapper, tapSchema);
        tapSchema.save();
        tapSchemaEditingBean.setTapSchema(tapSchema);
        return "tapSchemaEditing.xhtml?faces-redirect=true";
    }

    public String back() {
        return "schemaSelection.xhtml?faces-redirect=true";
    }
}
