package it.inaf.ia2.tsm.webapp;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * JAXB model for TSM web application configuration.
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
@XmlRootElement(name = "configuration")
public class Configuration {

    private CredentialsConfiguration credentialsConfiguration;
    private List<String> customUCDs;
    private String version;

    public Configuration() {
        version = Version.NUMBER;
        credentialsConfiguration = new CredentialsConfiguration();
        customUCDs = new ArrayList<>();
    }

    @XmlElement(name = "credentials-config")
    public CredentialsConfiguration getCredentialsConfiguration() {
        return credentialsConfiguration;
    }

    public void setCredentialsConfiguration(CredentialsConfiguration credentialsConfiguration) {
        this.credentialsConfiguration = credentialsConfiguration;
    }

    @XmlElementWrapper(name = "custom-ucds")
    @XmlElement(name = "ucd")
    public List<String> getCustomUCDs() {
        return customUCDs;
    }

    public void setCustomUCDs(List<String> customUCDs) {
        this.customUCDs = customUCDs;
    }

    @XmlAttribute(name = "version")
    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}
