/* 
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.api.contract;

/**
 * {@link TapSchemaEntity} that represents the table
 * {@code TAP_SCHEMA.key_columns}.
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public interface KeyColumn extends TapSchemaEntity {

    static final String KEY_ID_KEY = "key_id";
    static final String FROM_COLUMN_KEY = "from_column";
    static final String TARGET_COLUMN_KEY = "target_column";
    static final String KEY_COLUMN_ID_KEY = "key_columnID";

    Key getParent();
    
    /**
     * The value in the {@code key_id} column.
     */
    String getKeyId();

    void setKeyId(String keyId);

    /**
     * The value in the {@code from_column} column.
     */
    String getFromColumn();

    /**
     * The value in the {@code target_column} column.
     */
    String getTargetColumn();

    /**
     * The value in the {@code key_columnID} column: it represents [TODO]...
     */
    Long getKeyColumnID();

    void setKeyColumnID(Long keyColumnID);
}
