/* 
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.api;

import it.inaf.ia2.tsm.api.contract.Key;
import it.inaf.ia2.tsm.api.contract.KeyColumn;
import it.inaf.ia2.tsm.api.contract.TapSchema;
import java.util.Objects;

/**
 * The main implementation of {@link KeyColumn}.
 * 
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public class KeyColumnImpl extends TapSchemaEntityImpl implements KeyColumn {

    private static final long serialVersionUID = -3681677723432728327L;

    private Key key;

    private KeyColumnImpl() {
        // for serialization
        super();
    }

    protected KeyColumnImpl(DBWrapper dbWrapper, TapSchema tapSchema, Key key, String fromColumn, String targetColumn) {
        super(dbWrapper, tapSchema);
        this.key = key;

        addProperty(FROM_COLUMN_KEY, new FixedEntityProperty<>(fromColumn));
        addProperty(TARGET_COLUMN_KEY, new FixedEntityProperty<>(targetColumn));

        addProperty(KEY_ID_KEY, new EditableProperty<>(key.getId(), true));
        addProperty(KEY_COLUMN_ID_KEY, new EditableProperty<Long>());
    }

    @Override
    public Key getParent() {
        return key;
    }

    @Override
    public String getKeyId() {
        return getValue(KEY_ID_KEY, String.class);
    }

    @Override
    public void setKeyId(String keyId) {
        setValue(KEY_ID_KEY, keyId);
    }

    @Override
    public String getFromColumn() {
        return getValue(FROM_COLUMN_KEY, String.class);
    }

    @Override
    public String getTargetColumn() {
        return getValue(TARGET_COLUMN_KEY, String.class);
    }

    @Override
    public Long getKeyColumnID() {
        return getValue(KEY_COLUMN_ID_KEY, Long.class);
    }

    @Override
    public void setKeyColumnID(Long keyColumnID) {
        setValue(KEY_COLUMN_ID_KEY, keyColumnID);
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.key.getFromTableCompleteName());
        hash = 97 * hash + Objects.hashCode(this.getFromColumn());
        hash = 97 * hash + Objects.hashCode(this.key.getTargetTableCompleteName());
        hash = 97 * hash + Objects.hashCode(this.getTargetColumn());
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final KeyColumnImpl other = (KeyColumnImpl) obj;
        if (!Objects.equals(this.key.getFromTableCompleteName(), other.key.getFromTableCompleteName())) {
            return false;
        }
        if (!Objects.equals(this.getFromColumn(), other.getFromColumn())) {
            return false;
        }
        if (!Objects.equals(this.key.getTargetTableCompleteName(), other.key.getTargetTableCompleteName())) {
            return false;
        }
        if (!Objects.equals(this.getTargetColumn(), other.getTargetColumn())) {
            return false;
        }
        return true;
    }
}
