(function ($) {

    // Function factory to handle custom communications between the backing bean and JavaScript functions
    function eventHandlerFactory(handler, componentId) {
        return function (event) {
            if (event.status === 'success') {
                var srcId = componentId ? componentId : event.source.getAttribute('id');
                var jsUpdate = null, htmlUpdate = null;

                var jsupdates = event.responseXML.getElementById('jsupdates');
                if (jsupdates) {
                    jsupdates = jsupdates.childNodes;
                    for (var i = 0; i < jsupdates.length; i++) {
                        var jsu = jsupdates[i];
                        if (jsu.getAttribute('src') === srcId) {
                            jsUpdate = jsu.innerText || jsu.textContent;
                            break;
                        }
                    }
                }

                var htmlupdates = event.responseXML.getElementById('htmlupdates');
                if (htmlupdates) {
                    htmlupdates = htmlupdates.childNodes;
                    for (var i = 0; i < htmlupdates.length; i++) {
                        var hu = htmlupdates[i];
                        if (hu.getAttribute('src') === srcId) {
                            htmlUpdate = hu;
                            break;
                        }
                    }
                }

                handler(event.source, jsUpdate, htmlUpdate);
            }
        };
    }

    var COLUMNS_COMPONENT_ID = 'main:columns-list';
    var UCDRegExp;

    window.TSM = {
        initUCDValidator: function (UCDRegExpStr) {
            UCDRegExp = new RegExp(UCDRegExpStr);
        },
//        validateManualUCD: function (event) {
//            $clientValidationMessage = $('#ucd_search_form\\:ucd_validation_result');
//
//            var valid = UCDRegExp.test(event.target.value);
//            if (valid) {
//                $clientValidationMessage.empty();
//            } else {
//                $clientValidationMessage.text('Invalid UCD!');
//            }
//
//            $('#ucd_search_form\\:save_ucd').prop('disabled', !valid);
//        },
        displayUpdateOperations: eventHandlerFactory(function (srcElement, jsupdate) {
            $('#updateOperationsModal').modal('show');
        }),
        saveUCDCalled: eventHandlerFactory(function (srcElement, jsupdate) {
            if (jsupdate !== null) {
                $('#searchUCDModal').modal('hide');
            }
            // Hide loading
            $('.loading').addClass('hide');
        }),
        textInputChanged: eventHandlerFactory(function (srcElement, jsupdate) {
            $(srcElement).toggleClass('changed', jsupdate === 'true');
        }),
        stopPropagation: function (event) {
            event.stopPropagation();
            event.preventDefault();
            return false;
        },
        columnChanged: function (event) {
            if (event.status === 'success') {
                var $li = $(event.source).closest('li');
                $li.closest('ul').find('li').removeClass('active');
                $li.addClass('active');
            }
        },
        columnRemoved: eventHandlerFactory(function (srcElement, jsupdate, htmlupdate) {
            jsupdate = JSON.parse(jsupdate);
            var $ul = $(srcElement).closest('ul');
            $(srcElement).closest('a').find('span').addClass('strikeout');
            $(srcElement).prop('disabled', true);

            if (jsupdate.selectedColumn !== undefined) {
                $ul.find('li').removeClass('active');
                $ul.find('li:nth-child(' + (jsupdate.selectedColumn + 1) + ')').addClass('active');
            }
        }, COLUMNS_COMPONENT_ID),
        columnRemovalUndo: eventHandlerFactory(function (srcElement, jsupdate) {
            var $a = $('#main\\:columns-list\\:' + jsupdate + '\\:column-selector');
            $a.find('input').prop('disabled', false);
            $a.find('.strikeout').removeClass('strikeout');
            $a.removeClass('strikeout');
        }, COLUMNS_COMPONENT_ID),
        ucdTextKeyDown: function (event) {
            if (event.keyCode === 13) {
                $('#ucd_search_form\\:search_UCD_btn').click();
            }
        },
        openAddablesModal: function (event) {
            if (event.status === 'success') {
                $('#addablesModal').modal('show');
            }
        },
        entitiesAdded: function (event) {
            if (event.status === 'success') {
                $('#addablesModal').modal('hide');
            }
        },
        openSearchUCDModal: function (event) {
            if (event.status === 'success') {
                $('.loading').addClass('hide');
                $('#searchUCDModal').modal('show');
            }
        },
        closeSearchUCDModal: function (event) {
            if (event.status === 'success') {
                $('#searchUCDModal').modal('hide');
            }
        },
        notifyUpdate: function (event) {
            if (event.status === 'success' && $(event.responseXML).find('error').length === 0) {
                $('#updateSuccessModal').modal('show');
            }
        },
        UCDDescriptionAdded: function (event, index) {
            if (event.status === 'success') {
                $('#searchUCDModal .resultDefinition:eq(' + index + ')').collapse('show');
            }
        },
        showUCDDescription: function (event) {
            $(event.target).closest('.ucd-selector-group').next().collapse('toggle');
        },
        updateFromModal: function () {
            $('#updateOperationsModal').modal('hide');
            $('#main\\:update-btn').click();
        }
    };

    $(document).ready(function () {
        jsf.ajax.addOnError(function (error) {
            $('#errorModal .errorName').text(error.errorName);
            $('#errorModal .errorMessage').text(error.errorMessage);
            if (error.errorName.indexOf('NonexistentConversationException') !== -1
                    || error.errorName.indexOf('ViewExpiredException') !== -1) {
                // If conversation has expired reload the page to display error message
                location.reload();
            } else {
                $('#errorModal').modal('show');
            }
        });

        // Setup loading animation
        jsf.ajax.addOnEvent(function (data) {
            if ($(data.source).is('input[type="text"]')) {
                return; // special case
            }
            switch (data.status) {
                case "begin":
                    showWaiting();
                    break;
                case "complete":
                    hideWaiting();
                    break;
            }
        });
    });

})(jQuery);