/* 
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.webapp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
@Dependent
public class SearchUCDDialog implements Serializable {

    private static final long serialVersionUID = -3503024742241865133L;

    private boolean manualInsertion;

    private String UCDManualText;

    private String description;
    private boolean UCDnotFound;
    private String UCDServiceErrorMessage;
    private String selectedUCD;
    private String suggestedUCD;
    private List<UCDInfo> suggestedUCDs;

    private ParsedUCD parsedUCD;

    public SearchUCDDialog() {
        suggestedUCDs = new ArrayList<>();
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isUCDnotFound() {
        return UCDnotFound;
    }

    public String getSelectedUCD() {
        return selectedUCD;
    }

    public String getSuggestedUCD() {
        return suggestedUCD;
    }

    public List<UCDInfo> getSuggestedUCDs() {
        return suggestedUCDs;
    }

    public void setDefault() {
        UCDManualText = null;
        parsedUCD = null;

        description = null;
        UCDnotFound = false;
        selectedUCD = null;
        suggestedUCD = null;
        suggestedUCDs.clear();

        UCDServiceErrorMessage = null;
    }

    public void search(String description) {
        try {
            setDefault();
            this.description = description;

            String assignResponse = SearchUCD.assign(description);
            if (assignResponse == null) {
                UCDnotFound = true;
            } else {
                selectedUCD = assignResponse;
                suggestedUCD = assignResponse;

                List<UCDInfo> suggestResponse = SearchUCD.suggest(description);
                if (suggestResponse == null) {
                    UCDnotFound = true;
                } else {
                    suggestedUCDs = suggestResponse;
                }
            }
        } catch (UCDServiceException e) {
            setUCDServiceErrorMessage(e);
        }
    }

    public void selectUCD(String selectedUCD) {
        this.selectedUCD = selectedUCD;
    }

    public void explain(UCDInfo ucdInfo) {
        try {
            SearchUCD.explain(ucdInfo);
        } catch (UCDServiceException e) {
            setUCDServiceErrorMessage(e);
        }
    }

    public boolean isManualInsertion() {
        return manualInsertion;
    }

    public void setManualInsertion(boolean manualInsertion) {
        this.manualInsertion = manualInsertion;
    }

    public String getUCDServiceErrorMessage() {
        return UCDServiceErrorMessage;
    }

    private void setUCDServiceErrorMessage(UCDServiceException e) {
        setDefault();
        UCDServiceErrorMessage = e.getMessage();
    }

    public String getUCDManualText() {
        return UCDManualText;
    }

    public void setUCDManualText(String UCDManualText) {
        this.UCDManualText = UCDManualText;
    }

    public void validateManualUCD() {
        if (UCDManualText == null || UCDManualText.isEmpty() || UCDManualText.trim().isEmpty()) {
            parsedUCD = null;
        } else {
            parsedUCD = new ParsedUCD(UCDManualText);
        }
    }

    public String getUCDRegExp() {
        return SearchUCD.REG_EXP_UCD;
    }

    public String getNamespaceRegExp() {
        return SearchUCD.REG_EXP_START_WITH_NAMESPACE;
    }

    public ParsedUCD getParsedUCD() {
        return parsedUCD;
    }
}
