/* 
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.api.contract;

import it.inaf.ia2.tsm.api.ConsistencyChecks;
import java.sql.SQLException;

/**
 * Represents a TAP_SCHEMA.
 * 
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public interface TapSchema extends EntitiesContainer<Schema> {

    public static final String TABLES_TABLE = "tables";
    public static final String SCHEMAS_TABLE = "schemas";
    public static final String COLUMNS_TABLE = "columns";
    public static final String KEYS_TABLE = "keys";
    public static final String KEY_COLUMNS_TABLE = "key_columns";

    ConsistencyChecks getConsistencyChecks();
    
    /**
     * The name of the TAP_SCHEMA schema.
     */
    String getName();

    /**
     * The version selected for this TAP_SCHEMA.
     */
    TapSchemaVersion getVersion();

    /**
     * Save or update the TAP_SCHEMA changes into the database.
     */
    void save() throws SQLException;

    /**
     * Define if the TAP_SCHEMA schema was already written into the database.
     */
    boolean exists();
}
