/*
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.api;

/**
 *
 * @author Sonia Zorba <zorba at oats.inaf.it>
 */
public class InconsistentValue {

    private final String tapSchemaEntityType;

    private final String tapSchemaEntityDescription;

    private final String wrongPropertyName;

    private final Object currentValue;

    private final Object correctValue;

    public InconsistentValue(String tapSchemaEntityType, String tapSchemaEntityDescription, String wrongPropertyName, Object currentValue, Object correctValue) {
        this.tapSchemaEntityType = tapSchemaEntityType;
        this.tapSchemaEntityDescription = tapSchemaEntityDescription;
        this.wrongPropertyName = wrongPropertyName;
        this.currentValue = currentValue;
        this.correctValue = correctValue;
    }

    public String getTapSchemaEntityType() {
        return tapSchemaEntityType;
    }

    public String getTapSchemaEntityDescription() {
        return tapSchemaEntityDescription;
    }

    public String getWrongPropertyName() {
        return wrongPropertyName;
    }

    public Object getCurrentValue() {
        return currentValue;
    }

    public Object getCorrectValue() {
        return correctValue;
    }
}
