/* 
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.oats.ia2.tapschemamanager.webapp;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.xml.bind.JAXB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
@ApplicationScoped
public class WebAppConfigurationBean {

    private static final Logger log = LoggerFactory.getLogger(WebAppConfigurationBean.class);

    private File credentialsConfigFile;
    private String password;
    private CredentialsConfiguration cc;

    @PostConstruct
    public void init() {
        try {
            Properties prop = new Properties();
            try (InputStream in = getClass().getClassLoader().getResourceAsStream("webapp.properties")) {
                prop.load(in);
            }
            credentialsConfigFile = new File(prop.getProperty("credentials_config_path"));
            password = prop.getProperty("password");

            if (!credentialsConfigFile.exists()) {
                log.debug("Configuration file doesn't exist: creating a new one at " + credentialsConfigFile.getAbsolutePath());
                credentialsConfigFile.getParentFile().mkdirs();
                credentialsConfigFile.createNewFile();
                cc = new CredentialsConfiguration();
                JAXB.marshal(cc, credentialsConfigFile);
            } else {
                cc = JAXB.unmarshal(credentialsConfigFile, CredentialsConfiguration.class);
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CredentialsConfiguration getConfig() {
        return cc;
    }

    public void updateConfigurationFile() throws IOException {
        try (FileWriter fw = new FileWriter(credentialsConfigFile)) {
            JAXB.marshal(cc, fw);
        }
    }

    public String getPassword() {
        return password;
    }
}
