/* 
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.oats.ia2.tapschemamanager.webapp;

import it.inaf.oats.ia2.tapschemamanager.api.Credentials;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
@XmlRootElement(name = "credentials-config")
public class CredentialsConfiguration {

    private List<Object> credentialsInfo;

    public CredentialsConfiguration() {
        credentialsInfo = new ArrayList<>();
    }

    public void addCredentials(Credentials credentials) {
        credentialsInfo.add(credentials);
    }

    public void addSeparateCredentials(SeparateCredentials separateCredentials) {
        credentialsInfo.add(separateCredentials);
    }

    @XmlElements({
        @XmlElement(name = "credentials", type = Credentials.class),
        @XmlElement(name = "separate-credentials", type = SeparateCredentials.class)
    })
    public List<Object> getCredentialsInfo() {
        return credentialsInfo;
    }

    private void setCredentialsInfo(List<Object> credentialsInfo) {
        this.credentialsInfo = credentialsInfo;
    }
}
