/* 
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.oats.ia2.tapschemamanager.api.contract;

/**
 * {@link TapSchemaEntity} that represents the table {@code TAP_SCHEMA.schemas}.
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public interface Schema extends EntitiesContainer<Table>, ChildEntity<TapSchema> {

    final static String SCHEMA_NAME_KEY = "schema_name";
    final static String UTYPE_KEY = "utype";
    final static String DESCRIPTION_KEY = "description";
    final static String SCHEMA_ID = "schemaID";

    /**
     * The value in the {@code utype} column.
     */
    String getUtype();

    void setUtype(String utype);

    /**
     * The value in the {@code description} column.
     */
    String getDescription();

    void setDescription(String description);

    /**
     * The value in the {@code schemaID} column: it represents [TODO]...
     */
    Long getSchemaID();

    void setSchemaID(Long schemaID);
}
