/* 
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.oats.ia2.tapschemamanager.api.contract;

import java.util.List;

/**
 * {@link TapSchemaEntity} that represents the table {@code TAP_SCHEMA.keys}.
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public interface Key extends TapSchemaEntity {

    static final String ID_KEY = "key_id";
    static final String FROM_TABLE_KEY = "from_table";
    static final String TARGET_TABLE_KEY = "target_table";
    static final String DESCRIPTION_KEY = "description";
    static final String UTYPE_KEY = "utype";
    static final String KEY_ID_KEY = "keyID";

    /**
     * The value in the {@code key_id} column: represents the ID of the key (The
     * TAP standard define the {@code key_id} as a {@code VARCHAR}, but in our
     * implementation we assume it represents a numeric value).
     */
    String getId();

    void setId(String keyId);

    /**
     * List of the {@code KeyColumnEntity} owned by this {@code KeyEntity}.
     */
    List<KeyColumn> getKeyColumns();

    String getFromSchemaName();

    String getFromTableSimpleName();

    /**
     * The value in the {@code from_table} column: it is the complete name of
     * the table, as defined in the TAP standard: so it is
     * {@code &lt;schema-name&gt;.&lt;table-name&gt;}.
     */
    String getFromTableCompleteName();

    String getTargetSchemaName();

    String getTargetTableSimpleName();

    /**
     * The value in the {@code target_table} column: it is the complete name of
     * the table, as defined in the TAP standard: so it is
     * {@code &lt;schema-name&gt;.&lt;table-name&gt;}.
     */
    String getTargetTableCompleteName();

    /**
     * The value in the {@code utype} column.
     */
    String getUtype();

    void setUtype(String utype);

    /**
     * The value in the {@code description} column.
     */
    String getDescription();

    void setDescription(String description);

    /**
     * The value in the {@code keyID} column: it represents [TODO]...
     */
    Long getKeyID();

    void setKeyID(Long keyID);

    /**
     * A key is visible if all schemas, tables and columns involved with it have
     * {@link Status} {@code ADDED_PERSISTED} or {@code ADDED_NOT_PERSISTED}.
     */
    boolean isVisible();
}
