/* 
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.oats.ia2.tapschemamanager.api.contract;

/**
 * {@link TapSchemaEntity} that represents the table {@code TAP_SCHEMA.columns}.
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public interface Column extends ChildEntity<Table> {

    final static String TABLE_NAME_KEY = "table_name";
    final static String COLUMN_NAME_KEY = "column_name";
    final static String DATATYPE_KEY = "datatype";
    final static String SIZE_KEY = "size";
    final static String ARRAYSIZE_KEY = "arraysize";
    final static String DESCRIPTION_KEY = "description";
    final static String UTYPE_KEY = "utype";
    final static String UNIT_KEY = "unit";
    final static String UCD_KEY = "ucd";
    final static String INDEXED_KEY = "indexed";
    final static String PRINCIPAL_KEY = "principal";
    final static String STD_KEY = "std";
    final static String COLUMN_INDEX_KEY = "column_index";
    final static String ID_KEY = "id"; // IA2?
    final static String COLUMN_ID_KEY = "columnID";

    /**
     * The complete table name: {@code &lt;schema-name&gt;.&lt;table-name&gt;}.
     */
    String getTableCompleteName();

    /**
     * Indicates if the column is a primary key (or a part of a primary key).
     */
    boolean isPrimaryKey();

    /**
     * Retrieve (if it exists) the key of which this column is a "from column".
     */
    Key getForeignKey();

    /**
     * The value in the {@code datatype} column.
     */
    String getDatatype();

    Integer getArraySize();

    /**
     * The value in the {@code size} column.
     */
    Integer getSize();

    /**
     * The value in the {@code description} column.
     */
    String getDescription();

    void setDescription(String description);

    /**
     * The value in the {@code utype} column.
     */
    String getUtype();

    void setUtype(String utype);

    /**
     * The value in the {@code unit} column.
     */
    String getUnit();

    void setUnit(String unit);

    /**
     * The value in the {@code ucd} column: represents the Unified Content
     * Descriptor of the column.
     */
    String getUCD();

    void setUCD(String ucd);

    /**
     * The value in the {@code indexed} column: indicates that the column is
     * indexed.<br> It is an integer but should be treated as a boolean value.
     */
    boolean getIndexed();

    /**
     * The value in the {@code principal} column: indicates that the column is
     * considered a core part the content.<br> It is an integer but should be
     * treated as a boolean value.
     */
    boolean getPrincipal();

    void setPrincipal(boolean principal);

    /**
     * The value in the {@code std} column: indicates that the column is defined
     * by some standard.<br> It is an integer but should be treated as a boolean
     * value.
     */
    boolean getStd();

    void setStd(boolean std);

    Integer getColumnIndex();

    void setColumnIndex(Integer columnIndex);

    /**
     * The value in the {@code columnID} column: it represents [TODO]...
     */
    Long getColumnID();

    void setColumnID(Long columnID);
}
