/* 
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.oats.ia2.tapschemamanager.api;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Represent an {@code EntityProperty} which value can't be modified by the
 * user.
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public class FixedEntityProperty<T> implements EntityProperty, Serializable {

    private static final long serialVersionUID = -7009289405382798659L;
    private static final Logger log = LoggerFactory.getLogger(EntityPropertyInfo.class);

    private T value;

    public FixedEntityProperty(T value) {
        init(value);
    }

    @Override
    public final <X> void init(X initialValue) {
        this.value = (T) initialValue;
    }

    @Override
    public <X> X getValue(Class<X> type) {
        return (X) value;
    }
}
