(function ($, TSM) {

    // Function factory to handle custom communications between the backing bean and JavaScript functions
    function eventHandlerFactory(handler, componentId) {
        return function (event) {
            if (event.status === 'success') {
                var srcId = componentId ? componentId : event.source.getAttribute('id');
                var jsUpdate = null, htmlUpdate = null;

                var jsupdates = event.responseXML.getElementById('jsupdates');
                if (jsupdates) {
                    jsupdates = jsupdates.childNodes;
                    for (var i = 0; i < jsupdates.length; i++) {
                        var jsu = jsupdates[i];
                        if (jsu.getAttribute('src') === srcId) {
                            jsUpdate = jsu.innerText || jsu.textContent;
                            break;
                        }
                    }
                }

                var htmlupdates = event.responseXML.getElementById('htmlupdates');
                if (htmlupdates) {
                    htmlupdates = htmlupdates.childNodes;
                    for (var i = 0; i < htmlupdates.length; i++) {
                        var hu = htmlupdates[i];
                        if (hu.getAttribute('src') === srcId) {
                            htmlUpdate = hu;
                            break;
                        }
                    }
                }

                handler(event.source, jsUpdate, htmlUpdate);
            }
        };
    }

    var COLUMNS_COMPONENT_ID = 'main:columns-list';

    TSM.displayUpdateOperations = eventHandlerFactory(function (srcElement, jsupdate) {
        $('#updateOperationsModal').modal('show');
    });

    TSM.saveUCDCalled = eventHandlerFactory(function (srcElement, jsupdate) {
        if (jsupdate !== null) {
            $('#searchUCDModal').modal('hide');
        }
        // Hide loading
        $('.loading').addClass('hide');
    });

    TSM.textInputChanged = eventHandlerFactory(function (srcElement, jsupdate) {
        $(srcElement).toggleClass('changed', jsupdate === 'true');
    });

    TSM.stopPropagation = function (event) {
        event.stopPropagation();
        event.preventDefault();
        return false;
    };

    TSM.columnChanged = function (event) {
        if (event.status === 'success') {
            var $li = $(event.source).closest('li');
            $li.closest('ul').find('li').removeClass('active');
            $li.addClass('active');
        }
    };

    TSM.columnRemoved = eventHandlerFactory(function (srcElement, jsupdate, htmlupdate) {
        jsupdate = JSON.parse(jsupdate);
        var $ul = $(srcElement).closest('ul');
        $(srcElement).closest('a').find('span').addClass('strikeout');
        $(srcElement).prop('disabled', true);

        if (jsupdate.selectedColumn !== undefined) {
            $ul.find('li').removeClass('active');
            $ul.find('li:nth-child(' + (jsupdate.selectedColumn + 1) + ')').addClass('active');
        }
    }, COLUMNS_COMPONENT_ID);

    TSM.columnRemovalUndo = eventHandlerFactory(function (srcElement, jsupdate) {
        var $a = $('#main\\:columns-list\\:' + jsupdate + '\\:column-selector');
        $a.find('input').prop('disabled', false);
        $a.find('.strikeout').removeClass('strikeout');
        $a.removeClass('strikeout');
    }, COLUMNS_COMPONENT_ID);

    TSM.ucdTextKeyDown = function (event) {
        if (event.keyCode === 13) {
            $('#ucd_search_form\\:search_UCD_btn').click();
        }
    };

    TSM.openAddablesModal = function (event) {
        if (event.status === 'success') {
            $('#addablesModal').modal('show');
        }
    };

    TSM.entitiesAdded = function (event) {
        if (event.status === 'success') {
            $('#addablesModal').modal('hide');
        }
    };

    TSM.openSearchUCDModal = function (event) {
        if (event.status === 'success') {
            $('.loading').addClass('hide');
            $('#searchUCDModal').modal('show');
        }
    };

    TSM.closeSearchUCDModal = function (event) {
        if (event.status === 'success') {
            $('#searchUCDModal').modal('hide');
        }
    };

    TSM.notifyUpdate = function (event) {
        if (event.status === 'success' && $(event.responseXML).find('error').length === 0) {
            $('#updateSuccessModal').modal('show');
        }
    };

    TSM.updateFromModal = function () {
        $('#updateOperationsModal').modal('hide');
        $('#main\\:update-btn').click();
    };

})(jQuery, TSM);